/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.strings;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.ElementHolder;
import org.omnaest.utils.structure.element.converter.ElementConverter;

public class CharacterPathBuilder {
    public static CharacterPath buildPath(List<String> stringList) {
        CharacterPath retval = null;
        ArrayList<CharacterPath> characterPathRetlist = new ArrayList<CharacterPath>();
        if (stringList != null) {
            List<Character> firstCharacterList = ListUtils.filterExcludingNullElements(ListUtils.convert(stringList, new ElementConverter<String, Character>(){

                @Override
                public Character convert(String element) {
                    boolean elementIsEmptyOrNull = element == null || element.length() == 0;
                    return !elementIsEmptyOrNull ? Character.valueOf(element.charAt(0)) : null;
                }
            }));
            LinkedHashSet<Character> firstCharacterSet = new LinkedHashSet<Character>(firstCharacterList);
            for (Character firstCharacter : firstCharacterSet) {
                final ElementHolder<Boolean> hasEmptyElementHolder = new ElementHolder<Boolean>(false);
                List<String> stringListForCurrentCharacterWithRemovedFirstCharacter = ListUtils.filterExcludingNullElements(ListUtils.convert(ListUtils.filterIncludingIndexPositions(stringList, ListUtils.indexListOf(firstCharacterList, firstCharacter)), new ElementConverter<String, String>(){

                    @Override
                    public String convert(String element) {
                        String retval = null;
                        boolean elementIsEmptyOrNull = element == null || element.length() == 0;
                        String string = retval = elementIsEmptyOrNull ? null : element.substring(1);
                        if (StringUtils.isEmpty((CharSequence)retval)) {
                            hasEmptyElementHolder.setElement((Object)true);
                        }
                        return retval;
                    }
                }));
                CharacterPath characterPath = CharacterPathBuilder.buildPath(stringListForCurrentCharacterWithRemovedFirstCharacter);
                Character character = firstCharacter;
                ArrayList<CharacterPath> characterPathChildrenList = new ArrayList<CharacterPath>();
                if (characterPath != null) {
                    if (characterPath.isRoot()) {
                        characterPathChildrenList.addAll(characterPath.getCharacterPathChildrenList());
                    } else {
                        characterPathChildrenList.add(characterPath);
                    }
                }
                boolean leaf = (Boolean)hasEmptyElementHolder.getElement();
                characterPathRetlist.add(new CharacterPath(character, characterPathChildrenList, leaf));
            }
        }
        if (characterPathRetlist.size() > 1) {
            Character character = null;
            ArrayList<CharacterPath> characterPathChildrenList = characterPathRetlist;
            boolean leaf = false;
            retval = new CharacterPath(character, characterPathChildrenList, leaf);
        } else if (characterPathRetlist.size() == 1) {
            retval = (CharacterPath)characterPathRetlist.get(0);
        }
        return retval;
    }

    public static class CharacterPath {
        private Character character = null;
        private List<CharacterPath> characterPathChildrenList = null;
        private boolean leaf = false;

        public CharacterPath(Character character, List<CharacterPath> characterPathChildrenList, boolean leaf) {
            this.character = character;
            this.characterPathChildrenList = characterPathChildrenList;
            this.leaf = leaf;
        }

        public String determineFirstCharactersOfChildrenAsString() {
            CollectionUtils.CollectionTransformerToString<Character> collectionTransformer = new CollectionUtils.CollectionTransformerToString<Character>(){

                @Override
                public void process(Character character, StringBuilder resultStringBuilder) {
                    resultStringBuilder.append(character != null ? character : "");
                }
            };
            return CollectionUtils.convert(ListUtils.filterExcludingNullElements(ListUtils.convert(this.characterPathChildrenList, new ElementConverter<CharacterPath, Character>(){

                @Override
                public Character convert(CharacterPath characterPath) {
                    boolean characterPathIsEmptyOrNull = characterPath == null || characterPath.getCharacter() == null;
                    return !characterPathIsEmptyOrNull ? characterPath.getCharacter() : null;
                }
            })), collectionTransformer);
        }

        public Character getCharacter() {
            return this.character;
        }

        public List<CharacterPath> getCharacterPathChildrenList() {
            return this.characterPathChildrenList;
        }

        public CharacterPath matchingPath(String relativePath) {
            CharacterPath retval = null;
            if (relativePath != null && !relativePath.isEmpty()) {
                boolean isRootCharacterPath = this.character == null;
                String currentRelativePath = relativePath.substring(isRootCharacterPath ? 0 : 1);
                char firstCharacter = relativePath.charAt(0);
                if (isRootCharacterPath || this.character.equals(Character.valueOf(firstCharacter))) {
                    CharacterPath currentCharacterPath = this;
                    while (!currentRelativePath.isEmpty() && currentCharacterPath != null) {
                        firstCharacter = currentRelativePath.charAt(0);
                        List<CharacterPath> characterPathChildrenList = currentCharacterPath.getCharacterPathChildrenList();
                        currentCharacterPath = null;
                        for (CharacterPath characterPathChild : characterPathChildrenList) {
                            Character characterChild = characterPathChild.getCharacter();
                            if (characterChild == null || !characterChild.equals(Character.valueOf(firstCharacter))) continue;
                            currentCharacterPath = characterPathChild;
                            break;
                        }
                        currentRelativePath = currentRelativePath.substring(1);
                    }
                    if (currentCharacterPath != null) {
                        retval = currentCharacterPath;
                    }
                }
            }
            return retval;
        }

        public List<String> buildStringList() {
            ArrayList<String> retlist = new ArrayList<String>();
            final Character character = this.character;
            List<CharacterPath> characterPathChildrenList = this.characterPathChildrenList;
            if (!characterPathChildrenList.isEmpty()) {
                for (CharacterPath characterPathChild : characterPathChildrenList) {
                    List<String> childStringList = characterPathChild.buildStringList();
                    if (childStringList.isEmpty()) continue;
                    ElementConverter<String, String> elementTransformer = new ElementConverter<String, String>(){

                        @Override
                        public String convert(String element) {
                            return character + element;
                        }
                    };
                    List<String> transformedChildStringList = ListUtils.convert(childStringList, elementTransformer);
                    retlist.addAll(transformedChildStringList);
                }
            }
            if (characterPathChildrenList.isEmpty() || this.leaf) {
                retlist.add(String.valueOf(character));
            }
            return retlist;
        }

        public boolean hasNoChildren() {
            return this.characterPathChildrenList.isEmpty();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("\nCharacterPath [character=");
            builder.append(this.character);
            builder.append(", characterPathChildrenList=");
            builder.append(this.characterPathChildrenList);
            builder.append("]");
            return builder.toString();
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public boolean isRoot() {
            return this.getCharacter() == null;
        }
    }
}

