/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.strings;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.omnaest.utils.assertion.Assert;

public class StringReplacementBuilder {
    protected final Map<Pattern, String> regExPatternToReplacementMap = new LinkedHashMap<Pattern, String>();

    public StringReplacementBuilder add(String regEx, String replacement) {
        if (regEx != null) {
            try {
                Pattern pattern = Pattern.compile(regEx);
                if (pattern != null) {
                    this.regExPatternToReplacementMap.put(pattern, replacement);
                }
            }
            catch (Exception e) {
                Assert.fails("Failed to create Pattern for regEx=" + regEx + " and replacement=" + replacement, e);
            }
        }
        return this;
    }

    public StringReplacementBuilder addAll(Map<String, String> regExPatternStringToReplacementMap) {
        if (regExPatternStringToReplacementMap != null) {
            for (String regEx : regExPatternStringToReplacementMap.keySet()) {
                String replacement = regExPatternStringToReplacementMap.get(regEx);
                this.add(regEx, replacement);
            }
        }
        return this;
    }

    public String process(String value) {
        String retval = value;
        if (retval != null) {
            for (Map.Entry<Pattern, String> regExPatternToReplacementEntry : this.regExPatternToReplacementMap.entrySet()) {
                Pattern pattern = regExPatternToReplacementEntry.getKey();
                String replacement = regExPatternToReplacementEntry.getValue();
                retval = pattern.matcher(retval).replaceAll(replacement);
            }
        }
        return retval;
    }
}

