/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.strings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringReplacer {
    private final Pattern pattern;
    private int group = 0;

    public StringReplacer(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public StringReplacer(Pattern pattern) {
        this.pattern = pattern;
    }

    public ReplacementResult findAndRemoveFirst(String input) {
        boolean max = true;
        return this.findAndRemove(input, 1);
    }

    public ReplacementResult findAndRemoveAll(String input) {
        int max = Integer.MAX_VALUE;
        return this.findAndRemove(input, Integer.MAX_VALUE);
    }

    public ReplacementResult findAndRemove(String input, int max) {
        String replacement = "";
        return this.findAndReplace(input, "", max);
    }

    public ReplacementResult findAndReplaceAll(String input, String replacement) {
        int max = Integer.MAX_VALUE;
        return this.findAndReplace(input, replacement, Integer.MAX_VALUE);
    }

    public ReplacementResult findAndReplaceFirst(String input, String replacement) {
        boolean max = true;
        return this.findAndReplace(input, replacement, 1);
    }

    public ReplacementResult findAndReplace(String input, String replacement, int max) {
        StringBuffer stringBuilder = new StringBuffer();
        ArrayList<String> groupList = new ArrayList<String>();
        Matcher matcher = this.pattern.matcher(input);
        for (int ii = 0; ii < max && matcher.find(); ++ii) {
            groupList.add(matcher.group(this.group));
            matcher.appendReplacement(stringBuilder, replacement);
        }
        matcher.appendTail(stringBuilder);
        String[] matchingTokens = groupList.toArray(new String[0]);
        String output = stringBuilder.toString();
        return new ReplacementResult(matchingTokens, output);
    }

    public StringReplacer setGroup(int group) {
        this.group = group;
        return this;
    }

    public static class ReplacementResult {
        private final String[] matchingTokens;
        private final String output;

        ReplacementResult(String[] matchingTokens, String output) {
            this.matchingTokens = matchingTokens;
            this.output = output;
        }

        public String[] getMatchingTokens() {
            return this.matchingTokens;
        }

        public String getOutput() {
            return this.output;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ReplacementResult [matchingTokens=");
            builder.append(Arrays.toString(this.matchingTokens));
            builder.append(", output=");
            builder.append(this.output);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.matchingTokens);
            result = 31 * result + (this.output == null ? 0 : this.output.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ReplacementResult)) {
                return false;
            }
            ReplacementResult other = (ReplacementResult)obj;
            if (!Arrays.equals(this.matchingTokens, other.matchingTokens)) {
                return false;
            }
            return !(this.output == null ? other.output != null : !this.output.equals(other.output));
        }

        public boolean hasMatchingTokens() {
            return this.matchingTokens != null && this.matchingTokens.length > 0;
        }
    }
}

