/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.strings;

import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.StrTokenizer;
import org.omnaest.utils.strings.tokenizer.ConvertingCharacterSequenceTokenizerDecoratorToString;
import org.omnaest.utils.strings.tokenizer.PatternBasedCharacterSequenceTokenizer;

public class StringUtils {
    public static final String DEFAULT_LINESEPARATOR = System.getProperty("line.separator");

    public static boolean endsWithStartOfOther(String text, String textOther) {
        boolean retval = false;
        return retval;
    }

    public static String stringJoin(String[] strings, String delimiter) {
        String retval = null;
        StringBuffer sb = new StringBuffer("");
        boolean first = true;
        for (String iString : strings) {
            if (!first) {
                sb.append(delimiter);
            } else {
                first = false;
            }
            sb.append(iString);
        }
        if (sb.length() > 0) {
            retval = sb.toString();
        }
        return retval;
    }

    public static String insertString(String baseString, String insertString, int insertPosition, boolean overwrite) {
        StringBuffer sb;
        String retval = null;
        if (insertPosition < baseString.length()) {
            sb = new StringBuffer(baseString);
            for (int iInsertPosition = insertPosition; iInsertPosition < insertPosition + insertString.length() && iInsertPosition < baseString.length(); ++iInsertPosition) {
                int insertStringSourcePosition = iInsertPosition - insertPosition;
                if (overwrite) {
                    sb.deleteCharAt(iInsertPosition);
                }
                sb.insert(iInsertPosition, insertString.substring(insertStringSourcePosition, insertStringSourcePosition + 1));
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
        retval = sb.toString();
        return retval;
    }

    public static String setFixedWitdth(String value, int width) {
        if (width > 0) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)value)) {
                return String.format("%" + width + "s", value);
            }
            return org.apache.commons.lang3.StringUtils.repeat((String)" ", (int)width);
        }
        return "";
    }

    public static int maximumWidth(Iterable<String> iterable) {
        int retval = 0;
        if (iterable != null) {
            for (String value : iterable) {
                if (value == null) continue;
                retval = Math.max(retval, value.length());
            }
        }
        return retval;
    }

    public static String repeat(CharSequence token, int repeats) {
        StringBuilder stringBuilder = new StringBuilder();
        if (token != null && repeats > 0) {
            for (int ii = 1; ii <= repeats; ++ii) {
                stringBuilder.append(token);
            }
        }
        return stringBuilder.toString();
    }

    public static String percentageBar(double value, int width) {
        StringBuilder stringBuilder = new StringBuilder();
        value = Math.min(1.0, Math.max(value, 0.0));
        int widthOfArrow = (int)Math.round(value * (double)(width - 2));
        stringBuilder.append("[");
        if (widthOfArrow > 0) {
            stringBuilder.append(StringUtils.repeat("=", widthOfArrow - 1));
            stringBuilder.append(">");
        }
        stringBuilder.append(StringUtils.repeat(" ", width - 2 - widthOfArrow));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String[] splitByInterval(String text, int interval) {
        String[] retvals = null;
        if (text != null) {
            int length = text.length();
            interval = Math.max(1, interval);
            interval = Math.min(length, interval);
            int tokenNumber = (int)Math.ceil((double)length * 1.0 / (double)interval);
            retvals = new String[tokenNumber];
            for (int ii = 0; ii < tokenNumber; ++ii) {
                String token;
                int beginIndex = ii * interval;
                int endIndex = Math.min((ii + 1) * interval, length);
                retvals[ii] = token = text.substring(beginIndex, endIndex);
            }
        }
        return retvals;
    }

    public static String[] split(String text, char delimiter, char quote) {
        return new StrTokenizer(text, delimiter, quote).getTokenArray();
    }

    public static int count(String text, String regExSubstring) {
        int retval = 0;
        if (regExSubstring != null && text != null) {
            try {
                Pattern pattern = Pattern.compile(regExSubstring);
                Matcher matcher = pattern.matcher(text);
                while (matcher.find()) {
                    ++retval;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static Iterable<String> tokenizerPatternBased(CharSequence charSequence, String regexDelimiter) {
        return charSequence != null && regexDelimiter != null ? new ConvertingCharacterSequenceTokenizerDecoratorToString(new PatternBasedCharacterSequenceTokenizer(charSequence, regexDelimiter)) : null;
    }

    public static <E> String[] formatPerArrayElement(String format, E ... elements) {
        ArrayList<String> retlist = new ArrayList<String>();
        if (format != null && elements != null) {
            for (E element : elements) {
                retlist.add(String.format(format, element));
            }
        }
        return retlist.toArray(new String[0]);
    }

    public static <E> String[] formatPerArrayElement(Locale locale, String format, E ... elements) {
        ArrayList<String> retlist = new ArrayList<String>();
        if (format != null && elements != null) {
            for (E element : elements) {
                retlist.add(String.format(locale, format, element));
            }
        }
        return retlist.toArray(new String[0]);
    }

    public static String[] findAll(String regex, String text) {
        return StringUtils.findAll(Pattern.compile(regex), text);
    }

    public static String[] findAll(Pattern pattern, String text) {
        ArrayList<String> retlist = new ArrayList<String>();
        if (pattern != null && text != null) {
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                retlist.add(matcher.group());
            }
        }
        return retlist.toArray(new String[0]);
    }
}

