/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.strings.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.omnaest.utils.structure.collection.list.ListUtils;

public interface Grammar {
    public TokenPath declare();

    public static class TokenPath {
        private List<StackElement> stackList = new ArrayList<StackElement>();

        public TokenPath add(Token abc) {
            this.stackList.add(new StackElementPattern(abc.getPattern()));
            return this;
        }

        public TokenPath add(String text) {
            this.stackList.add(new StackElementPattern(Pattern.compile(text)));
            return this;
        }

        public TokenPath execute(TokenAction tokenAction) {
            StackElement lastElement = this.determineLastStackElement();
            if (lastElement != null) {
                lastElement.setTokenAction(tokenAction);
            }
            return this;
        }

        private StackElement determineLastStackElement() {
            return ListUtils.lastElement(this.stackList);
        }

        public TokenPath or(TokenPath ... tokenPathes) {
            if (tokenPathes != null && tokenPathes.length > 0) {
                this.stackList.add(new StackElementTokenPath(tokenPathes));
            }
            return this;
        }

        public TokenPath add(TokenPath tokenPath) {
            this.stackList.add(new StackElementTokenPath(new TokenPath[]{tokenPath}));
            return this;
        }

        public TokenPath withLookup(int lookup) {
            StackElement lastElement = this.determineLastStackElement();
            if (lastElement != null) {
                lastElement.setLookup(lookup);
            }
            return this;
        }

        protected Iterator<StackElement> stackIterator() {
            return this.stackList.iterator();
        }

        static class StackElementPattern
        extends StackElement {
            private final Pattern pattern;

            private StackElementPattern(Pattern pattern) {
                this.pattern = pattern;
            }

            Pattern getPattern() {
                return this.pattern;
            }
        }

        static class StackElementTokenPath
        extends StackElement {
            private final TokenPath[] tokenPathes;

            private StackElementTokenPath(TokenPath ... tokenPathes) {
                this.tokenPathes = tokenPathes;
            }

            TokenPath[] getTokenPathes() {
                return this.tokenPathes;
            }

            @Override
            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("StackElementTokenPath [tokenPathes=");
                builder.append(Arrays.toString(this.tokenPathes));
                builder.append("]");
                return builder.toString();
            }
        }

        static abstract class StackElement {
            protected TokenAction tokenAction;
            protected int lookup = -1;

            protected TokenAction getTokenAction() {
                return this.tokenAction;
            }

            protected int getLookup() {
                return this.lookup;
            }

            protected StackElement() {
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("StackElement [tokenAction=");
                builder.append(this.tokenAction);
                builder.append(", lookup=");
                builder.append(this.lookup);
                builder.append("]");
                return builder.toString();
            }

            private void setTokenAction(TokenAction tokenAction) {
                this.tokenAction = tokenAction;
            }

            private void setLookup(int lookup) {
                this.lookup = lookup;
            }
        }
    }

    public static interface TokenAction {
        public void execute(String var1);
    }

    public static class Token {
        private final Pattern pattern;

        public Token(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public Token(Pattern pattern) {
            this.pattern = pattern;
        }

        private Pattern getPattern() {
            return this.pattern;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Token [pattern=");
            builder.append(this.pattern);
            builder.append("]");
            return builder.toString();
        }
    }
}

