/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.strings.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.strings.parser.Grammar;
import org.omnaest.utils.structure.collection.list.ListUtils;

public class ParserState {
    private Grammar grammar;

    ParserState(Grammar grammar) {
        this.grammar = grammar;
    }

    public boolean parse(String text) {
        boolean retval = false;
        Grammar.TokenPath tokenPath = this.grammar.declare();
        int lookup = -1;
        List<Match> matchList = this.parseInternal(text, tokenPath, -1);
        if (matchList != null) {
            retval = true;
            for (Match match : matchList) {
                String token = match.getToken();
                Grammar.TokenAction[] tokenActions = match.getTokenActions();
                if (tokenActions == null) continue;
                for (Grammar.TokenAction tokenAction : tokenActions) {
                    tokenAction.execute(token);
                }
            }
        }
        return retval;
    }

    private List<Match> parseInternal(String remainingText, Iterator<Grammar.TokenPath.StackElement> stackIterator, int lookup) {
        List<Match> retlist;
        block3: {
            int normalizedLookup;
            Grammar.TokenPath.StackElement stackElement;
            block4: {
                Matcher matcher;
                int reducedLookup;
                block5: {
                    boolean stackHasNext = stackIterator.hasNext();
                    boolean remainingTextIsEmpty = StringUtils.isEmpty((CharSequence)remainingText);
                    ArrayList<Match> arrayList = retlist = !stackHasNext && remainingTextIsEmpty ? new ArrayList<Match>() : null;
                    if (!stackHasNext || lookup > -1 && lookup <= 0) break block3;
                    stackElement = stackIterator.next();
                    int localLookup = stackElement.getLookup();
                    reducedLookup = Math.max(Math.max(lookup - 1, localLookup), -1);
                    normalizedLookup = Math.max(Math.max(lookup, localLookup), -1);
                    if (!(stackElement instanceof Grammar.TokenPath.StackElementPattern)) break block4;
                    Grammar.TokenPath.StackElementPattern stackElementPattern = (Grammar.TokenPath.StackElementPattern)stackElement;
                    Pattern pattern = stackElementPattern.getPattern();
                    matcher = pattern.matcher(remainingText);
                    boolean lookingAt = matcher.lookingAt();
                    if (!lookingAt) break block3;
                    if (!remainingTextIsEmpty) break block5;
                    retlist = ListUtils.emptyList();
                    break block3;
                }
                int end = matcher.end();
                String remainingTextNew = StringUtils.substring((String)remainingText, (int)end);
                retlist = this.parseInternal(remainingTextNew, stackIterator, reducedLookup);
                if (retlist == null) break block3;
                String token = matcher.group();
                Grammar.TokenAction tokenAction = stackElement.getTokenAction();
                Match match = new Match(token);
                match.addTokenAction(tokenAction);
                retlist = ListUtils.add(retlist, 0, match);
                break block3;
            }
            if (stackElement instanceof Grammar.TokenPath.StackElementTokenPath) {
                Grammar.TokenPath.StackElementTokenPath stackElementTokenPath = (Grammar.TokenPath.StackElementTokenPath)stackElement;
                Grammar.TokenPath[] tokenPathes = stackElementTokenPath.getTokenPathes();
                Grammar.TokenAction tokenAction = stackElement.getTokenAction();
                if (tokenPathes != null) {
                    for (Grammar.TokenPath tokenPathCurrent : tokenPathes) {
                        retlist = this.parseInternal(remainingText, tokenPathCurrent, normalizedLookup);
                        if (retlist == null) continue;
                        Match lastElement = ListUtils.lastElement(retlist);
                        if (lastElement == null) break;
                        lastElement.addTokenAction(tokenAction);
                        break;
                    }
                }
            }
        }
        return retlist;
    }

    private List<Match> parseInternal(String remainingText, Grammar.TokenPath tokenPath, int lookup) {
        return this.parseInternal(remainingText, tokenPath.stackIterator(), lookup);
    }

    private static class Match {
        private final String token;
        private Grammar.TokenAction[] tokenActions = null;

        private Match(String token) {
            this.token = token;
        }

        private String getToken() {
            return this.token;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Match [token=");
            builder.append(this.token);
            builder.append(", tokenActions=");
            builder.append(Arrays.toString(this.tokenActions));
            builder.append("]");
            return builder.toString();
        }

        private Grammar.TokenAction[] getTokenActions() {
            return this.tokenActions;
        }

        public void addTokenAction(Grammar.TokenAction tokenAction) {
            if (tokenAction != null) {
                this.tokenActions = (Grammar.TokenAction[])ArrayUtils.add((Object[])this.tokenActions, (Object)tokenAction);
            }
        }
    }
}

