/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.strings.tokenizer;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omnaest.utils.strings.tokenizer.CharacterSequenceTokenizer;

public class PatternBasedCharacterSequenceTokenizer
implements CharacterSequenceTokenizer {
    private final CharSequence charSequence;
    private final String regexDelimiter;

    public PatternBasedCharacterSequenceTokenizer(CharSequence charSequence, String regexDelimiter) {
        this.charSequence = charSequence;
        this.regexDelimiter = regexDelimiter;
    }

    @Override
    public Iterator<CharSequence> iterator() {
        Pattern pattern = Pattern.compile(this.regexDelimiter);
        final Matcher matcher = pattern.matcher(this.charSequence);
        return new Iterator<CharSequence>(){
            private boolean hasReadTail = false;
            private boolean hasToReadNewCharacterSequence = true;
            private CharSequence nextCharacterSequence = null;

            private CharSequence readNextCharacterSequence() {
                CharSequence retval = null;
                if (!this.hasToReadNewCharacterSequence) {
                    retval = this.nextCharacterSequence;
                } else if (!this.hasReadTail) {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean find = matcher.find();
                    if (find) {
                        matcher.appendReplacement(stringBuffer, "");
                    } else {
                        matcher.appendTail(stringBuffer);
                        this.hasReadTail = true;
                    }
                    this.nextCharacterSequence = retval = stringBuffer;
                    this.hasToReadNewCharacterSequence = false;
                }
                return retval;
            }

            @Override
            public boolean hasNext() {
                CharSequence nextCharacterSequence = this.readNextCharacterSequence();
                return nextCharacterSequence != null;
            }

            @Override
            public CharSequence next() {
                CharSequence nextCharacterSequence = this.readNextCharacterSequence();
                this.hasToReadNewCharacterSequence = true;
                return nextCharacterSequence;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

