/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.array;

import org.omnaest.utils.structure.collection.list.ListAbstract;

public class ArrayToListAdapter<E>
extends ListAbstract<E> {
    private static final long serialVersionUID = 2716942711754587491L;
    protected final E[] array;

    public ArrayToListAdapter(E[] array) {
        this.array = array;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean add(E e) {
        ArrayToListAdapter.throwUnsupportedOperationException();
        return false;
    }

    private static void throwUnsupportedOperationException() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Can not modify size of an array, please use the set(int,E) method instead");
    }

    @Override
    public E get(int index) {
        return this.array[index];
    }

    @Override
    public E set(int index, E element) {
        E retval = this.array[index];
        this.array[index] = element;
        return retval;
    }

    @Override
    public void add(int index, E element) {
        ArrayToListAdapter.throwUnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        ArrayToListAdapter.throwUnsupportedOperationException();
        return null;
    }

    @Override
    public int indexOf(Object o) {
        int retval = -1;
        for (int index = 0; index < this.size(); ++index) {
            E element = this.get(index);
            if (element != o && (element == null || !element.equals(o))) continue;
            retval = index;
            break;
        }
        return retval;
    }

    @Override
    public int lastIndexOf(Object o) {
        int retval = -1;
        for (int index = this.size() - 1; index >= 0; --index) {
            E element = this.get(index);
            if (element != o && (element == null || !element.equals(o))) continue;
            retval = index;
            break;
        }
        return retval;
    }
}

