/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.array;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.iterator.IterableUtils;

public class ArrayUtils {
    public static <E> E[] merge(E[] ... elementArrays) {
        ArrayList<E> retlist = new ArrayList<E>();
        Class<?> componentType = null;
        for (E[] elements : elementArrays) {
            if (elements == null) continue;
            if (componentType == null) {
                componentType = ArrayUtils.componentType(elements.getClass());
            }
            retlist.addAll(Arrays.asList(elements));
        }
        return componentType != null ? retlist.toArray((Object[])Array.newInstance(componentType, retlist.size())) : null;
    }

    public static <TO, FROM> TO[] convertArray(FROM[] arrayFrom, Class<TO> arrayToType, ElementConverter<FROM, ? extends TO> elementConverter) {
        Object[] arrayTo = arrayFrom != null ? Array.newInstance(arrayToType, arrayFrom.length) : new Object[]{};
        return ArrayUtils.convertArray(arrayFrom, arrayTo, elementConverter);
    }

    public static <TO, FROM> TO[] convertArray(FROM[] arrayFrom, TO[] arrayTo, ElementConverter<FROM, ? extends TO> elementConverter) {
        TO[] retvals = null;
        if (arrayTo != null && arrayFrom != null && elementConverter != null) {
            if (arrayTo.length == arrayFrom.length) {
                retvals = arrayTo;
                int index = 0;
                for (FROM element : arrayFrom) {
                    TO convertedElement = elementConverter.convert(element);
                    retvals[index++] = convertedElement;
                }
            } else {
                Class<?> arrayToType = ArrayUtils.componentType(arrayTo.getClass());
                retvals = ArrayUtils.convertArray(arrayFrom, arrayToType, elementConverter);
            }
        }
        return retvals;
    }

    public static <TO, FROM> TO[] convertArrayExcludingNullElements(FROM[] arrayFrom, TO[] arrayTo, ElementConverter<FROM, TO> elementConverter) {
        List<TO> listTo = ListUtils.convertExcludingNullElements(Arrays.asList(arrayFrom), elementConverter);
        return listTo == null ? null : listTo.toArray(arrayTo);
    }

    public static String[] trimStringArrayTokens(String[] stringArray) {
        String[] retvals = null;
        if (stringArray != null) {
            retvals = new String[stringArray.length];
            for (int ii = 0; ii < retvals.length; ++ii) {
                String value = stringArray[ii];
                retvals[ii] = value = value != null ? value.trim() : null;
            }
        }
        return retvals;
    }

    public static Object[] toObject(Object primitiveArray) {
        Object[] retvals = null;
        if (primitiveArray != null) {
            try {
                Class<?> primitiveArrayType = primitiveArray.getClass();
                Class<?> componentType = primitiveArrayType.getComponentType();
                if (componentType.isPrimitive()) {
                    componentType = ObjectUtils.primitiveWrapperTypeFor(componentType);
                }
                int length = Array.getLength(primitiveArray);
                retvals = (Object[])Array.newInstance(componentType, length);
                for (int ii = 0; ii < retvals.length; ++ii) {
                    retvals[ii] = Array.get(primitiveArray, ii);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retvals;
    }

    public static boolean isArrayType(Class<?> type) {
        return type != null && type.isArray();
    }

    public static boolean isArray(Object object) {
        return object != null && ArrayUtils.isArrayType(object.getClass());
    }

    public static Class<?> componentType(Class<?> arrayType) {
        return ArrayUtils.isArrayType(arrayType) ? arrayType.getComponentType() : null;
    }

    public static int length(Object arrayObject) {
        return arrayObject != null && ArrayUtils.isArray(arrayObject) ? Array.getLength(arrayObject) : -1;
    }

    public static <E> E[] valueOf(Collection<? extends E> collection, Class<E> type) {
        Object[] retvals = null;
        if (collection != null) {
            retvals = collection.toArray((Object[])Array.newInstance(type != null ? type : Object.class, collection.size()));
        }
        return retvals;
    }

    public static <E> E[] valueOf(Iterable<? extends E> iterable, Class<E> type) {
        Object[] retvals = null;
        if (iterable != null) {
            List<E> list = ListUtils.valueOf(iterable);
            retvals = list.toArray((Object[])Array.newInstance(type != null ? type : Object.class, list.size()));
        }
        return retvals;
    }

    public static <E> E[] valueOf(E ... elements) {
        boolean inherited = true;
        boolean onlyReturnInterfaces = false;
        boolean intersection = true;
        Class[] types = ArrayUtils.convertArray(elements, Class.class, new ElementConverter<E, Class>(){

            @Override
            public Class convert(E element) {
                return element != null ? element.getClass() : null;
            }
        });
        Set<Class<?>> assignableTypeSet = ReflectionUtils.assignableTypeSet(true, false, true, types);
        Class<?> type = IterableUtils.firstElement(assignableTypeSet);
        return ArrayUtils.valueOf(type, elements);
    }

    public static <E> E[] valueOf(Class<E> type, E ... elements) {
        Object[] retvals = null;
        Class componentType = type == null ? Object.class : type;
        int length = elements.length;
        retvals = (Object[])Array.newInstance(componentType, length);
        for (int ii = 0; ii < length; ++ii) {
            retvals[ii] = elements[ii];
        }
        return retvals;
    }

    public static int sumOf(int ... values) {
        int retval = 0;
        for (int value : values) {
            retval += value;
        }
        return retval;
    }

    public static <E> BitSet differenceBitSet(E[] elements1, E[] elements2) {
        BitSet retvals = new BitSet();
        if (elements1 == null && elements2 != null) {
            retvals.set(0, elements2.length);
        } else if (elements1 != null && elements2 == null) {
            retvals.set(0, elements1.length);
        } else if (elements1 != null && elements2 != null) {
            for (int ii = 0; ii < elements1.length || ii < elements2.length; ++ii) {
                if (ii >= elements1.length || ii >= elements2.length) {
                    retvals.set(ii);
                    continue;
                }
                if (org.apache.commons.lang3.ObjectUtils.equals(elements1[ii], elements2[ii])) continue;
                retvals.set(ii);
            }
        }
        return retvals;
    }

    public static <E> Class<E[]> arrayType(Class<E> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }
}

