/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.omnaest.utils.structure.collection.CollectionUtils;

public abstract class CollectionAbstract<E>
implements Collection<E>,
Serializable {
    private static final long serialVersionUID = 3810482055181299089L;

    @Override
    public void clear() {
        this.removeAll(new ArrayList(this));
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean retval = false;
        if (collection != null) {
            for (E element : collection) {
                if (element == null) continue;
                retval |= this.add(element);
            }
        }
        return retval;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean retval;
        block1: {
            retval = true;
            if (collection == null) break block1;
            for (Object object : collection) {
                if (!(retval &= this.contains(object))) break;
            }
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean retval = false;
        if (c != null) {
            for (Object o : c) {
                retval |= this.remove(o);
            }
        }
        return retval;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retval = false;
        if (c != null) {
            ArrayList removeList = new ArrayList();
            for (Object element : this) {
                if (c.contains(element)) continue;
                removeList.add(element);
                retval = true;
            }
            this.removeAll(removeList);
        }
        return retval;
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] retval = new Object[size];
        Iterator iterator = this.iterator();
        for (int ii = 0; ii < size && iterator.hasNext(); ++ii) {
            retval[ii] = iterator.next();
        }
        return retval;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] retval = null;
        if (a != null) {
            int size = this.size();
            if (a.length != size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Iterator iterator = this.iterator();
            for (int ii = 0; ii < size; ++ii) {
                a[ii] = iterator.next();
            }
            retval = a;
        }
        return retval;
    }

    @Override
    public int hashCode() {
        return CollectionUtils.hashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Iterable) {
            return CollectionUtils.equals(this, (Iterable)object);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Arrays.toString(this.toArray()));
        return builder.toString();
    }
}

