/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection;

import java.util.Collection;
import java.util.Iterator;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.collection.CollectionAbstract;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.iterator.IteratorUtils;

public class CollectionComposite<E>
extends CollectionAbstract<E> {
    private static final long serialVersionUID = 4042012340715370368L;
    private final Collection<E>[] collections;

    public CollectionComposite(Collection<E> ... collections) {
        this.collections = collections;
    }

    public CollectionComposite(Collection<Collection<E>> collectionOfCollections) {
        Assert.isNotNull(collectionOfCollections, "The given collection of collections must not be null");
        this.collections = collectionOfCollections.toArray(new Collection[collectionOfCollections.size()]);
    }

    @Override
    public int size() {
        int retval = 0;
        for (Collection<E> collection : this.collections) {
            if (collection == null) continue;
            retval += collection.size();
        }
        return retval;
    }

    @Override
    public boolean contains(Object o) {
        boolean retval = false;
        for (Collection<E> collection : this.collections) {
            if (collection == null || !collection.contains(o)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    @Override
    public Iterator<E> iterator() {
        return IteratorUtils.chained(ArrayUtils.convertArray(this.collections, Iterator.class, new ElementConverter<Collection<E>, Iterator<E>>(){

            @Override
            public Iterator<E> convert(Collection<E> collection) {
                return collection != null ? collection.iterator() : null;
            }
        }));
    }

    @Override
    public boolean add(E e) {
        boolean retval = false;
        Collection<E> currentCollection = null;
        int currentSize = Integer.MAX_VALUE;
        for (Collection<E> collection : this.collections) {
            int size = collection.size();
            if (size >= currentSize) continue;
            currentCollection = collection;
            currentSize = size;
        }
        if (currentCollection != null) {
            retval = currentCollection.add(e);
        }
        return retval;
    }

    @Override
    public boolean remove(Object o) {
        boolean retval = false;
        for (Collection<E> collection : this.collections) {
            if (collection == null) continue;
            retval |= collection.remove(o);
        }
        return retval;
    }
}

