/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection;

import com.google.common.base.Joiner;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.structure.collection.CollectionComposite;
import org.omnaest.utils.structure.collection.adapter.CollectionToCollectionAdapter;
import org.omnaest.utils.structure.collection.decorator.LockingCollectionDecorator;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterElementToMapEntry;
import org.omnaest.utils.structure.element.converter.ElementConverterObjectToString;
import org.omnaest.utils.structure.iterator.IteratorUtils;
import org.omnaest.utils.structure.map.MapUtils;

public class CollectionUtils {
    public static void addAll(Collection<Integer> integerCollection, int[] intArray) {
        for (int iValue : intArray) {
            integerCollection.add(iValue);
        }
    }

    public static void addAll(Collection<Long> longCollection, long[] intArray) {
        for (long iValue : intArray) {
            longCollection.add(iValue);
        }
    }

    public static <E> boolean containsObjectIdentity(Collection<E> collection, Object object) {
        return CollectionUtils.indexOfObjectIdentity(collection, object) >= 0;
    }

    public static <FROM, TO> TO convert(Collection<FROM> collection, CollectionConverter<FROM, TO> collectionConverter) {
        TO retval = null;
        if (collection != null && collectionConverter != null) {
            for (FROM element : collection) {
                collectionConverter.process(element);
            }
            retval = collectionConverter.result();
        }
        return retval;
    }

    public static <TO, FROM> Collection<TO> convertCollection(Collection<FROM> collectionFrom, ElementConverter<FROM, TO> elementConverter) {
        return ListUtils.convert(collectionFrom, elementConverter);
    }

    public static <TO, FROM> Collection<TO> convertCollectionExcludingNullElements(Collection<FROM> collectionFrom, ElementConverter<FROM, TO> elementConverter) {
        return ListUtils.convertExcludingNullElements(collectionFrom, elementConverter);
    }

    public static boolean equals(Iterable<?> collection1, Iterable<?> collection2) {
        boolean retval = false;
        if (collection1 != null && collection2 != null) {
            Iterator<?> iteratorOther = collection2.iterator();
            Iterator<?> iteratorThis = collection1.iterator();
            retval = true;
            while (iteratorOther.hasNext() && iteratorThis.hasNext()) {
                Object elementOther = iteratorOther.next();
                Object elementThis = iteratorThis.next();
                if (retval &= elementThis == elementOther || elementThis != null && elementThis.equals(elementOther)) continue;
                break;
            }
            retval &= !iteratorOther.hasNext() && !iteratorThis.hasNext();
        }
        return retval;
    }

    public static boolean equalsUnordered(Collection<?> collection1, Collection<?> collection2) {
        boolean retval = collection1.size() == collection2.size();
        for (Object iObject : collection1) {
            retval &= collection2.contains(iObject);
        }
        return retval;
    }

    public static <E> int hashCode(Collection<E> collection) {
        int prime = 31;
        int result = 1;
        if (collection != null) {
            for (E next : collection) {
                result = 31 * result + (next != null ? next.hashCode() : 0);
            }
        }
        return result;
    }

    public static <E> int hashCodeUnordered(Collection<E> collection) {
        int result = 1;
        if (collection != null) {
            for (E next : collection) {
                result *= next != null ? next.hashCode() : 0;
            }
        }
        return result;
    }

    public static <E> int indexOfObjectIdentity(Collection<E> collection, Object object) {
        Iterator<E> iterator;
        int retval = -1;
        if (collection != null && (iterator = collection.iterator()) != null) {
            int indexPosition = 0;
            while (retval < 0 && iterator.hasNext()) {
                E element = iterator.next();
                if (element == object) {
                    retval = indexPosition;
                }
                ++indexPosition;
            }
        }
        return retval;
    }

    public static <E> int lastIndexOfObjectIdentity(Collection<E> collection, Object object) {
        Iterator<E> iterator;
        int retval = -1;
        if (collection != null && (iterator = collection.iterator()) != null) {
            int indexPosition = 0;
            boolean lastElementWasIdenticalElement = false;
            while ((retval < 0 || lastElementWasIdenticalElement) && iterator.hasNext()) {
                lastElementWasIdenticalElement = false;
                E element = iterator.next();
                if (element == object) {
                    retval = indexPosition;
                    lastElementWasIdenticalElement = true;
                }
                ++indexPosition;
            }
        }
        return retval;
    }

    public static <E> Collection<E> mergeAll(Collection<E> ... collections) {
        return ListUtils.mergeAll(collections);
    }

    public static String toString(Iterable<?> iterable) {
        StringBuilder retval = new StringBuilder();
        retval.append("[");
        boolean first = true;
        for (Object iElement : iterable) {
            try {
                retval.append(!first ? "," : "");
                retval.append("\n " + String.valueOf(iElement));
            }
            catch (Exception e) {
                // empty catch block
            }
            first = false;
        }
        retval.append("\n]\n");
        return retval.toString();
    }

    public static <E> String toString(Collection<E> collection, Joiner joiner, String prefix, String suffix) {
        return StringUtils.defaultString((String)prefix) + CollectionUtils.toString(collection, joiner) + StringUtils.defaultString((String)suffix);
    }

    public static <E> String toString(Collection<E> collection, Joiner joiner) {
        ElementConverterObjectToString elementConverter = new ElementConverterObjectToString();
        return CollectionUtils.toString(collection, elementConverter, joiner);
    }

    public static <E> String toString(Collection<E> collection, ElementConverter<E, String> elementConverter, Joiner joiner) {
        if (joiner == null) {
            joiner = Joiner.on((String)",");
        }
        List<String> partList = ListUtils.convert(collection, elementConverter);
        return joiner.join(partList);
    }

    public static double sumOfCollectionDouble(Iterable<Double> doubleIterable) {
        double retval = 0.0;
        for (Double iValue : doubleIterable) {
            if (iValue == null) continue;
            retval += iValue.doubleValue();
        }
        return retval;
    }

    public static int sumOfCollectionInteger(Iterable<Integer> integerIterable) {
        int retval = 0;
        for (Integer iValue : integerIterable) {
            if (iValue == null) continue;
            retval += iValue.intValue();
        }
        return retval;
    }

    public static <E> E[] toArray(Collection<E> collection, Class<? extends E> clazz) {
        Object[] retvals = null;
        if (collection != null) {
            try {
                retvals = (Object[])Array.newInstance(clazz, collection.size());
                Iterator<E> iterator = collection.iterator();
                int indexPosition = 0;
                while (iterator.hasNext()) {
                    retvals[indexPosition] = iterator.next();
                    ++indexPosition;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retvals;
    }

    public static int[] toArrayInt(Collection<Integer> integerCollection) {
        int[] retvals = new int[integerCollection.size()];
        int ii = 0;
        for (Integer iValue : integerCollection) {
            retvals[ii++] = iValue;
        }
        return retvals;
    }

    public static <K, V, E> Map<K, V> toMap(Iterable<E> iterable, ElementConverterElementToMapEntry<E, K, V> elementToMapEntryTransformer) {
        return MapUtils.valueOf(iterable, elementToMapEntryTransformer);
    }

    public static <E> Collection<E> locked(Collection<E> collection, Lock lock) {
        return new LockingCollectionDecorator<E>(collection, lock);
    }

    public static <E> Collection<E> lockedByReentrantLock(Collection<E> collection) {
        ReentrantLock lock = new ReentrantLock();
        return new LockingCollectionDecorator<E>(collection, lock);
    }

    public static <E> void drainTo(Iterable<E> iterable, Collection<E> collection) {
        if (iterable != null && collection != null) {
            Iterator<E> iterator = iterable.iterator();
            IteratorUtils.drainTo(iterator, collection);
        }
    }

    public static <E> void drainTo(Iterable<E> iterable, Collection<E> collection, int maxNumberOfElements) {
        if (iterable != null && collection != null) {
            Iterator<E> iterator = iterable.iterator();
            IteratorUtils.drainTo(iterator, collection, maxNumberOfElements);
        }
    }

    public static <E> void copyIntoCollectionFrom(Collection<E> collection, Iterable<E> iterable) {
        if (collection != null && iterable != null) {
            for (E element : iterable) {
                collection.add(element);
            }
        }
    }

    public static <E> void copyIntoCollectionFrom(Collection<E> collection, Iterable<E> iterable, int maxNumberOfElements) {
        if (collection != null && iterable != null) {
            Iterator<E> iterator = iterable.iterator();
            CollectionUtils.copyIntoCollectionFrom(collection, iterator, maxNumberOfElements);
        }
    }

    public static <E> void copyIntoCollectionFrom(Collection<E> collection, Iterator<E> iterator) {
        if (collection != null && iterator != null) {
            while (iterator.hasNext()) {
                E element = iterator.next();
                collection.add(element);
            }
        }
    }

    public static <E> void copyIntoCollectionFrom(Collection<E> collection, Iterator<E> iterator, int maxNumberOfElements) {
        if (collection != null && iterator != null) {
            for (int ii = 0; ii < maxNumberOfElements && iterator.hasNext(); ++ii) {
                E element = iterator.next();
                collection.add(element);
            }
        }
    }

    public static <FROM, TO> Collection<TO> adapter(Collection<FROM> collection, ElementBidirectionalConverter<FROM, TO> elementBidirectionalConverter) {
        return new CollectionToCollectionAdapter<FROM, TO>(collection, elementBidirectionalConverter);
    }

    public static <E> Collection<E> composite(Collection<Collection<E>> collectionOfCollections) {
        return new CollectionComposite<E>(collectionOfCollections);
    }

    public static <E> Collection<E> composite(Collection<E> ... collections) {
        return new CollectionComposite<E>(collections);
    }

    public static abstract class CollectionTransformerToString<FROM>
    implements CollectionConverter<FROM, String> {
        private StringBuilder resultStringBuilder = new StringBuilder();

        @Override
        public void process(FROM element) {
            this.process(element, this.resultStringBuilder);
        }

        public abstract void process(FROM var1, StringBuilder var2);

        @Override
        public String result() {
            return this.resultStringBuilder.toString();
        }
    }

    public static interface CollectionConverter<FROM, TO> {
        public void process(FROM var1);

        public TO result();
    }
}

