/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.tuple.TupleTwo;

public class ComparatorUtils {
    public static <T> Comparator<T> comparatorUsingListIndexPosition(final List<T> list) {
        Assert.isNotNull(list);
        return new Comparator<T>(){

            @Override
            public int compare(T element1, T element2) {
                int indexPosition2;
                int retval = 0;
                int indexPosition1 = list.indexOf(element1);
                if (indexPosition1 == (indexPosition2 = list.indexOf(element2))) {
                    retval = 0;
                } else if (indexPosition1 == -1) {
                    retval = 1;
                } else if (indexPosition2 == -1) {
                    retval = -1;
                } else if (indexPosition1 < indexPosition2) {
                    retval = -1;
                } else if (indexPosition1 > indexPosition2) {
                    retval = 1;
                }
                return retval;
            }
        };
    }

    public static <T> Comparator<T> comparatorDecoratorUsingWeakHashMapCache(final Comparator<T> comparator) {
        return comparator == null ? null : new Comparator<T>(){
            private Map<TupleTwo<T, T>, Integer> objectAndObjectTupleToComparisonValueMap = new WeakHashMap();

            @Override
            public int compare(T valueFirst, T valueSecond) {
                TupleTwo keyTuple = new TupleTwo(valueFirst, valueSecond);
                Integer comparisonValue = this.objectAndObjectTupleToComparisonValueMap.get(keyTuple);
                if (comparisonValue == null) {
                    comparisonValue = comparator.compare(valueFirst, valueSecond);
                    this.objectAndObjectTupleToComparisonValueMap.put(keyTuple, comparisonValue);
                }
                return comparisonValue;
            }
        };
    }
}

