/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.adapter;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Iterator;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.CollectionAbstract;
import org.omnaest.utils.structure.collection.CollectionUtils;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.iterator.IteratorToIteratorAdapter;

public abstract class CollectionToCollectionAdapterBase<FROM, TO>
extends CollectionAbstract<TO> {
    private static final long serialVersionUID = -6369301794639842338L;
    protected final ElementBidirectionalConverter<FROM, TO> elementBidirectionalConverter;

    protected CollectionToCollectionAdapterBase(ElementBidirectionalConverter<FROM, TO> elementBidirectionalConverter) {
        this.elementBidirectionalConverter = elementBidirectionalConverter;
        Assert.isNotNull(elementBidirectionalConverter, "elementBidirectionalConverter must not be null");
    }

    @Override
    public int size() {
        return this.getCollection().size();
    }

    @Override
    public boolean contains(Object o) {
        FROM elementConverted = this.tryConvertBackwards(o);
        return this.getCollection().contains(elementConverted);
    }

    private FROM tryConvertBackwards(Object o) {
        FROM elementConverted = null;
        try {
            Object element = o;
            elementConverted = this.elementBidirectionalConverter.convertBackwards(element);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return elementConverted;
    }

    @Override
    public Iterator<TO> iterator() {
        Iterator<FROM> iterator = this.getCollection().iterator();
        return new IteratorToIteratorAdapter<TO, FROM>(iterator, this.elementBidirectionalConverter);
    }

    @Override
    public boolean add(TO element) {
        return this.getCollection().add(this.elementBidirectionalConverter.convertBackwards(element));
    }

    @Override
    public boolean remove(Object o) {
        return this.getCollection().remove(this.tryConvertBackwards(o));
    }

    protected abstract Collection<FROM> getCollection();

    @Override
    public String toString() {
        return CollectionUtils.toString(this, Joiner.on((String)","), "[", "]");
    }
}

