/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.decorator;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.omnaest.utils.structure.collection.decorator.CollectionDecorator;
import org.omnaest.utils.structure.iterator.IteratorUtils;

public class LockingCollectionDecorator<E>
extends CollectionDecorator<E> {
    private static final long serialVersionUID = -5999653460495392274L;
    protected final Lock lock;

    public LockingCollectionDecorator(Collection<E> collection, Lock lock) {
        super(collection);
        this.lock = lock;
    }

    public LockingCollectionDecorator(Collection<E> collection) {
        super(collection);
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int retval = 0;
        this.lock.lock();
        try {
            retval = super.size();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.isEmpty();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.contains(o);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    @Override
    public Iterator<E> iterator() {
        return IteratorUtils.lockedIterator(super.iterator(), this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] retval = null;
        this.lock.lock();
        try {
            retval = super.toArray();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        T[] retval = null;
        this.lock.lock();
        try {
            retval = super.toArray(a);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.add(e);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.remove(o);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.containsAll(c);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.addAll(c);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.removeAll(c);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.retainAll(c);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.lock();
        try {
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.equals(o);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int retval = 0;
        this.lock.lock();
        try {
            retval = super.hashCode();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String retval = null;
        this.lock.lock();
        try {
            retval = super.toString();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }
}

