/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list;

import java.util.List;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.list.decorator.ListDecorator;

public class BooleanList
extends ListDecorator<Boolean> {
    private static final long serialVersionUID = 3614309493148716282L;

    public BooleanList(List<Boolean> list) {
        super(list);
        Assert.isNotNull(list, "list must not be null");
    }

    public boolean containsAtLeastOneTrueValue() {
        return this.contains(true);
    }

    public boolean containsAtLeastOneFalseValue() {
        return this.contains(false);
    }

    public boolean containsOnlyFalseValues() {
        boolean retval = true;
        for (Boolean value : this) {
            if (!value.booleanValue()) continue;
            retval = false;
            break;
        }
        return retval;
    }

    public boolean containsOnlyTrueValues() {
        boolean retval = true;
        for (Boolean value : this) {
            if (value.booleanValue()) continue;
            retval = false;
            break;
        }
        return retval;
    }

    public boolean containsAtLeastNumberOfTrueValues(int numberOfTrueValues) {
        boolean retval = false;
        int counter = 0;
        for (Boolean value : this) {
            if (!value.booleanValue() || ++counter < numberOfTrueValues) continue;
            retval = true;
            break;
        }
        return retval;
    }
}

