/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.omnaest.utils.structure.collection.list.IndexList;

public class IndexArrayList<E extends Comparable<? super E>>
implements IndexList<E> {
    private ArrayList<E> dataList = null;
    private ArrayList<DataAndIndexPostionInOriginalList> indexList = null;
    private final IndexElementComparator indexElementComparator = new IndexElementComparator();

    public IndexArrayList() {
        this(0);
    }

    public IndexArrayList(int initialSize) {
        this.dataList = new ArrayList(initialSize);
        this.indexList = new ArrayList(0);
    }

    public IndexArrayList(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        boolean retval = true;
        retval = this.dataList.add(e);
        if (retval) {
            this.addToIndexList(e, this.dataList.size() - 1);
        }
        return retval;
    }

    private void addToIndexList(E e, int dataListIndexPosition) {
        int indexPosition = this.determineIndexListIndexPosition(e);
        if (indexPosition < 0) {
            indexPosition = (indexPosition + 1) * -1;
        }
        this.indexList.add(indexPosition, new DataAndIndexPostionInOriginalList(this, e, dataListIndexPosition));
    }

    private int determineIndexListIndexPosition(E e) {
        int retval = -1;
        DataAndIndexPostionInOriginalList dataAndIndexPositionInOriginalList = new DataAndIndexPostionInOriginalList(this, e, 0);
        retval = Collections.binarySearch(this.indexList, dataAndIndexPositionInOriginalList, this.indexElementComparator);
        return retval;
    }

    private int[] determineDataListIndexPositions(E e) {
        int[] retvals = null;
        List<DataListWithIndexListIndexPosition> dataListWithIndexListIndexPositionList = this.determineDataListAndIndexListIndexPositionList(e);
        if (dataListWithIndexListIndexPositionList.size() > 0) {
            retvals = new int[dataListWithIndexListIndexPositionList.size()];
            for (int ii = 0; ii < retvals.length; ++ii) {
                retvals[ii] = dataListWithIndexListIndexPositionList.get(ii).getDataListIndexPosition();
            }
        }
        return retvals;
    }

    private List<DataListWithIndexListIndexPosition> determineDataListAndIndexListIndexPositionList(E e) {
        ArrayList<DataListWithIndexListIndexPosition> retlist = new ArrayList<DataListWithIndexListIndexPosition>(0);
        ArrayList<Integer> indexListIndexPositionList = new ArrayList<Integer>(0);
        int startIndexPosition = this.determineIndexListIndexPosition(e);
        if (startIndexPosition >= 0) {
            Object indexData;
            boolean loopAgain;
            indexListIndexPositionList.add(startIndexPosition);
            int lowerIndexPosition = startIndexPosition - 1;
            int upperIndexPosition = startIndexPosition + 1;
            do {
                loopAgain = false;
                if (lowerIndexPosition < 0 || lowerIndexPosition >= this.indexList.size()) continue;
                indexData = this.indexList.get(lowerIndexPosition).getData();
                if ((e != null || indexData != null) && !indexData.equals(e)) continue;
                indexListIndexPositionList.add(lowerIndexPosition);
                --lowerIndexPosition;
                loopAgain = true;
            } while (loopAgain);
            do {
                loopAgain = false;
                if (upperIndexPosition < 0 || upperIndexPosition >= this.indexList.size()) continue;
                indexData = this.indexList.get(upperIndexPosition).getData();
                if ((e != null || indexData != null) && (indexData == null || !indexData.equals(e))) continue;
                indexListIndexPositionList.add(upperIndexPosition);
                ++upperIndexPosition;
                loopAgain = true;
            } while (loopAgain);
        }
        if (indexListIndexPositionList.size() > 0) {
            for (Integer iIndexPosition : indexListIndexPositionList) {
                DataListWithIndexListIndexPosition dataListWithIndexListIndexPosition = new DataListWithIndexListIndexPosition();
                dataListWithIndexListIndexPosition.setDataListIndexPosition(this.indexList.get(iIndexPosition).getIndexPositionInDataList());
                dataListWithIndexListIndexPosition.setIndexListIndexPosition(iIndexPosition);
                retlist.add(dataListWithIndexListIndexPosition);
            }
        }
        return retlist;
    }

    private IndexBoundaries determineDataListAndIndexListIndexPositionBoundaries(E e) {
        IndexBoundaries retval = new IndexBoundaries();
        List<DataListWithIndexListIndexPosition> dataListWithIndexListPositionList = this.determineDataListAndIndexListIndexPositionList(e);
        if (dataListWithIndexListPositionList.size() > 0) {
            Collections.sort(dataListWithIndexListPositionList, new Comparator<DataListWithIndexListIndexPosition>(){

                @Override
                public int compare(DataListWithIndexListIndexPosition o1, DataListWithIndexListIndexPosition o2) {
                    return Integer.valueOf(o1.getDataListIndexPosition()).compareTo(o2.getDataListIndexPosition());
                }
            });
            DataListWithIndexListIndexPosition upperData = dataListWithIndexListPositionList.get(dataListWithIndexListPositionList.size() - 1);
            retval.setUpper(upperData);
            DataListWithIndexListIndexPosition lowerData = dataListWithIndexListPositionList.get(0);
            retval.setLower(lowerData);
        }
        return retval;
    }

    private int determineIndexListIndexPosition(int dataListIndexPosition) {
        int retval = -1;
        Comparable element = (Comparable)this.dataList.get(dataListIndexPosition);
        List<DataListWithIndexListIndexPosition> dataListWithIndexListIndexPositionList = this.determineDataListAndIndexListIndexPositionList(element);
        for (DataListWithIndexListIndexPosition iDataListWithIndexListIndexPosition : dataListWithIndexListIndexPositionList) {
            if (iDataListWithIndexListIndexPosition.getDataListIndexPosition() != dataListIndexPosition) continue;
            retval = iDataListWithIndexListIndexPosition.getIndexListIndexPosition();
            break;
        }
        return retval;
    }

    @Override
    public void add(int index, E element) {
        this.dataList.add(index, element);
        this.updateIndexDataListIndexPositionsWithCorrectureOffset(index, 1);
        this.addToIndexList(element, index);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean retval = true;
        for (Comparable iElement : c) {
            boolean insertSuccess = this.dataList.add(iElement);
            if (insertSuccess) {
                this.addToIndexList(iElement, this.dataList.size() - 1);
            }
            retval &= insertSuccess;
        }
        return retval;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean retval = true;
        int indexOffset = 0;
        for (Comparable iElement : c) {
            int insertIndex = index + indexOffset;
            this.dataList.add(insertIndex, iElement);
            this.addToIndexList(iElement, insertIndex);
            ++indexOffset;
        }
        return retval;
    }

    @Override
    public void clear() {
        this.dataList.clear();
        this.indexList.clear();
    }

    @Override
    public boolean contains(Object o) {
        boolean retval = false;
        retval = this.determineIndexListIndexPosition((Comparable)o) >= 0;
        return retval;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean retval = true;
        for (Object iObjectElement : c) {
            retval &= this.contains(iObjectElement);
        }
        return retval;
    }

    @Override
    public E get(int index) {
        return (E)((Comparable)this.dataList.get(index));
    }

    @Override
    public int indexOf(Object o) {
        int retval = -1;
        DataListWithIndexListIndexPosition lowerIndexPosition = this.determineDataListAndIndexListIndexPositionBoundaries((Comparable)o).getLower();
        if (lowerIndexPosition != null) {
            retval = lowerIndexPosition.getDataListIndexPosition();
        }
        return retval;
    }

    @Override
    public int[] indexesOfElementsGreaterThan(E element) {
        int[] retval = null;
        int indexListStartIndexPosition = this.determineIndexListIndexPositionOfFirstElementGreaterThan(element);
        if (indexListStartIndexPosition >= 0) {
            int[] dataListIndexPositions;
            int[] indexListIndexPositions = new int[this.indexList.size() - indexListStartIndexPosition];
            for (int ii = 0; ii < indexListIndexPositions.length; ++ii) {
                indexListIndexPositions[ii] = indexListStartIndexPosition + ii;
            }
            retval = dataListIndexPositions = this.determineDataListIndexPositionsFromIndexListIndexPositions(indexListIndexPositions);
        }
        return retval;
    }

    @Override
    public int[] indexesOfElementsLessThan(E element) {
        int[] retval = null;
        int indexListEndIndexPosition = this.determineIndexListIndexPositionOfLastElementLessThan(element);
        if (indexListEndIndexPosition >= 0) {
            int[] dataListIndexPositions;
            int[] indexListIndexPositions = new int[indexListEndIndexPosition + 1];
            for (int ii = 0; ii < indexListIndexPositions.length; ++ii) {
                indexListIndexPositions[ii] = ii;
            }
            retval = dataListIndexPositions = this.determineDataListIndexPositionsFromIndexListIndexPositions(indexListIndexPositions);
        }
        return retval;
    }

    @Override
    public int[] indexesOfElementsEqualOrBetween(E smallestElement, E largestElement) {
        int[] retval = null;
        int indexListStartIndexPosition = this.determineIndexListIndexPositionOfLastElementLessThan(smallestElement);
        int indexListEndIndexPosition = this.determineIndexListIndexPositionOfFirstElementGreaterThan(largestElement);
        if (indexListEndIndexPosition >= 0 || indexListStartIndexPosition >= 0) {
            indexListStartIndexPosition = indexListStartIndexPosition < 0 ? 0 : ++indexListStartIndexPosition;
            indexListEndIndexPosition = indexListEndIndexPosition < 0 ? this.indexList.size() - 1 : --indexListEndIndexPosition;
        }
        if (indexListStartIndexPosition >= 0 && indexListEndIndexPosition >= 0 && indexListStartIndexPosition <= indexListEndIndexPosition) {
            int[] dataListIndexPositions;
            int[] indexListIndexPositions = new int[indexListEndIndexPosition - indexListStartIndexPosition + 1];
            for (int ii = 0; ii < indexListIndexPositions.length; ++ii) {
                indexListIndexPositions[ii] = indexListStartIndexPosition + ii;
            }
            retval = dataListIndexPositions = this.determineDataListIndexPositionsFromIndexListIndexPositions(indexListIndexPositions);
        }
        return retval;
    }

    private int[] determineDataListIndexPositionsFromIndexListIndexPositions(int[] indexListIndexPositions) {
        int[] retval = new int[indexListIndexPositions.length];
        int counter = 0;
        for (int iIndexListIndexPosition : indexListIndexPositions) {
            retval[counter++] = this.indexList.get(iIndexListIndexPosition).getIndexPositionInDataList();
        }
        return retval;
    }

    private int determineIndexListIndexPositionOfFirstElementGreaterThan(E element) {
        int retval = -1;
        int leftBorder = 0;
        int rightBorder = this.indexList.size();
        int indexListSize = this.indexList.size();
        int previousMiddlePosition = -1;
        boolean looping = true;
        while (looping) {
            looping = false;
            int middlePosition = (leftBorder + rightBorder) / 2;
            if (middlePosition != previousMiddlePosition && middlePosition >= 0 && middlePosition < indexListSize) {
                Object currentDataElement = this.indexList.get(middlePosition).getData();
                int currentElementCompare = this.indexElementComparator.compare(currentDataElement, element);
                int previousElementCompare = -1;
                if (middlePosition > 0) {
                    Object previousDataElement = this.indexList.get(middlePosition - 1).getData();
                    previousElementCompare = this.indexElementComparator.compare(previousDataElement, element);
                }
                if (currentElementCompare > 0) {
                    if (previousElementCompare <= 0) {
                        retval = middlePosition;
                        looping = false;
                    } else {
                        rightBorder = middlePosition - 1;
                        looping = true;
                    }
                } else {
                    leftBorder = middlePosition + 1;
                    looping = true;
                }
                previousMiddlePosition = middlePosition;
                continue;
            }
            retval = middlePosition * -1 - 1;
            looping = false;
        }
        return retval;
    }

    private int determineIndexListIndexPositionOfLastElementLessThan(E element) {
        int retval = -1;
        int leftBorder = 0;
        int rightBorder = this.indexList.size();
        int indexListSize = this.indexList.size();
        int previousMiddlePosition = -1;
        boolean looping = true;
        while (looping) {
            looping = false;
            int middlePosition = (leftBorder + rightBorder) / 2;
            if (middlePosition != previousMiddlePosition && middlePosition >= 0 && middlePosition < indexListSize) {
                Object currentDataElement = this.indexList.get(middlePosition).getData();
                int currentElementCompare = this.indexElementComparator.compare(currentDataElement, element);
                int followingElementCompare = -1;
                if (middlePosition + 1 < indexListSize) {
                    Object followingDataElement = this.indexList.get(middlePosition + 1).getData();
                    followingElementCompare = this.indexElementComparator.compare(followingDataElement, element);
                }
                if (currentElementCompare < 0) {
                    if (followingElementCompare >= 0) {
                        retval = middlePosition;
                        looping = false;
                    } else {
                        leftBorder = middlePosition + 1;
                        looping = true;
                    }
                } else {
                    rightBorder = middlePosition - 1;
                    looping = true;
                }
                previousMiddlePosition = middlePosition;
                continue;
            }
            retval = middlePosition * -1 - 1;
            looping = false;
        }
        return retval;
    }

    @Override
    public int[] indexesOf(E e) {
        return this.determineDataListIndexPositions(e);
    }

    @Override
    public boolean isEmpty() {
        return this.dataList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.dataList.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        int retval = -1;
        DataListWithIndexListIndexPosition dataListWithIndexListIndexPosition = this.determineDataListAndIndexListIndexPositionBoundaries((Comparable)o).getUpper();
        if (dataListWithIndexListIndexPosition != null) {
            retval = dataListWithIndexListIndexPosition.getDataListIndexPosition();
        }
        return retval;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.dataList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.dataList.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        boolean retval = false;
        DataListWithIndexListIndexPosition dataListWithIndexListIndexPosition = this.determineDataListAndIndexListIndexPositionBoundaries((Comparable)o).getLower();
        if (dataListWithIndexListIndexPosition != null) {
            int indexListIndexPosition;
            int dataListIndexPosition = dataListWithIndexListIndexPosition.getDataListIndexPosition();
            retval = this.remove(dataListIndexPosition, indexListIndexPosition = dataListWithIndexListIndexPosition.getIndexListIndexPosition()) != null;
        }
        return retval;
    }

    @Override
    public E remove(int dataListIndexPosition) {
        E retval = null;
        if (dataListIndexPosition >= 0 && dataListIndexPosition < this.dataList.size()) {
            int indexListIndexPosition = this.determineIndexListIndexPosition(dataListIndexPosition);
            this.remove(dataListIndexPosition, indexListIndexPosition);
        }
        return retval;
    }

    private E remove(int dataListIndexPosition, int indexListIndexPosition) {
        Comparable retval = null;
        if (indexListIndexPosition >= 0 && indexListIndexPosition < this.indexList.size() && dataListIndexPosition >= 0 && dataListIndexPosition < this.dataList.size()) {
            this.indexList.remove(indexListIndexPosition);
            this.updateIndexDataListIndexPositionsWithCorrectureOffset(dataListIndexPosition, -1);
            retval = (Comparable)this.dataList.remove(dataListIndexPosition);
        }
        return (E)retval;
    }

    private void updateIndexDataListIndexPositionsWithCorrectureOffset(int beginDataListIndexPosition, int correctureOffset) {
        for (int ii = 0; ii < this.indexList.size(); ++ii) {
            DataAndIndexPostionInOriginalList dataAndIndexPostionInOriginalList = this.indexList.get(ii);
            int dataListIndexPosition = dataAndIndexPostionInOriginalList.getIndexPositionInDataList();
            if (dataListIndexPosition < beginDataListIndexPosition) continue;
            dataAndIndexPostionInOriginalList.setIndexPositionInDataList(dataListIndexPosition + correctureOffset);
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean retval = false;
        for (Object iObjectElement : c) {
            retval |= this.remove(iObjectElement);
        }
        return retval;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retval = true;
        ArrayList<Comparable> removeList = new ArrayList<Comparable>(0);
        for (Comparable iElement : this.dataList) {
            if (c.contains(iElement)) continue;
            removeList.add(iElement);
        }
        retval = this.removeAll(removeList);
        return retval;
    }

    @Override
    public E set(int index, E element) {
        Comparable retval = null;
        if (index >= 0 && this.dataList.size() > index) {
            int indexListIndexPosition = this.determineIndexListIndexPosition(index);
            if (indexListIndexPosition >= 0) {
                this.indexList.remove(indexListIndexPosition);
            }
            this.addToIndexList(element, index);
            retval = (Comparable)this.dataList.set(index, element);
        }
        return (E)retval;
    }

    @Override
    public int size() {
        return this.dataList.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.dataList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.dataList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.dataList.toArray(a);
    }

    public void printDataList() {
        for (Comparable iElement : this.dataList) {
            System.out.println(iElement);
        }
    }

    public void printIndexList() {
        for (DataAndIndexPostionInOriginalList iElement : this.indexList) {
            System.out.println(iElement.getData() + ":" + iElement.getIndexPositionInDataList());
        }
    }

    private class DataListWithIndexListIndexPosition {
        private int dataListIndexPosition = -1;
        private int indexListIndexPosition = -1;

        private DataListWithIndexListIndexPosition() {
        }

        public int getDataListIndexPosition() {
            return this.dataListIndexPosition;
        }

        public void setDataListIndexPosition(int dataListIndexPosition) {
            this.dataListIndexPosition = dataListIndexPosition;
        }

        public int getIndexListIndexPosition() {
            return this.indexListIndexPosition;
        }

        public void setIndexListIndexPosition(int indexListIndexPosition) {
            this.indexListIndexPosition = indexListIndexPosition;
        }
    }

    private class IndexBoundaries {
        private DataListWithIndexListIndexPosition lower = null;
        private DataListWithIndexListIndexPosition upper = null;

        private IndexBoundaries() {
        }

        public DataListWithIndexListIndexPosition getLower() {
            return this.lower;
        }

        public void setLower(DataListWithIndexListIndexPosition lower) {
            this.lower = lower;
        }

        public DataListWithIndexListIndexPosition getUpper() {
            return this.upper;
        }

        public void setUpper(DataListWithIndexListIndexPosition upper) {
            this.upper = upper;
        }
    }

    private class IndexElementComparator
    implements Comparator<DataAndIndexPostionInOriginalList> {
        private IndexElementComparator() {
        }

        @Override
        public int compare(E e1, E e2) {
            int retval;
            if (e1 != null && e2 != null) {
                retval = e1.compareTo(e2);
            } else if (e1 != null && e2 == null) {
                try {
                    retval = e1.compareTo(e2);
                }
                catch (NullPointerException e) {
                    retval = -1;
                }
            } else if (e1 == null && e2 != null) {
                try {
                    retval = -1 * e2.compareTo(e1);
                }
                catch (NullPointerException e) {
                    retval = 1;
                }
            } else {
                retval = 0;
            }
            return retval;
        }

        @Override
        public int compare(DataAndIndexPostionInOriginalList o1, DataAndIndexPostionInOriginalList o2) {
            int retval;
            if (o1 != null && o2 != null) {
                Object e1 = o1.getData();
                Object e2 = o2.getData();
                retval = this.compare((E)e1, (E)e2);
            } else {
                retval = o1 != null && o2 == null ? -1 : (o1 == null && o2 != null ? 1 : 0);
            }
            return retval;
        }
    }

    private class DataAndIndexPostionInOriginalList {
        private E data = null;
        private int indexPositionInDataList = -1;
        final /* synthetic */ IndexArrayList this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public DataAndIndexPostionInOriginalList(E e, int dataListIndexPosition) {
            this.this$0 = (IndexArrayList)n;
            this.data = e;
            this.indexPositionInDataList = dataListIndexPosition;
        }

        public int getIndexPositionInDataList() {
            return this.indexPositionInDataList;
        }

        public E getData() {
            return this.data;
        }

        public void setIndexPositionInDataList(int indexPositionInDataList) {
            this.indexPositionInDataList = indexPositionInDataList;
        }
    }
}

