/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list;

import java.util.Collection;
import java.util.LinkedList;

public class LimitedLinkedList<E>
extends LinkedList<E> {
    private static final long serialVersionUID = 8220551181941161150L;
    private int sizeMax = -1;
    private boolean removeFirstElementByExceedingSize = true;

    public LimitedLinkedList(Collection<? extends E> collection, int sizeMax) {
        super(collection);
        this.sizeMax = sizeMax;
        this.ensureMaximumSize();
    }

    public LimitedLinkedList(int sizeMax) {
        this();
        this.sizeMax = sizeMax;
    }

    public LimitedLinkedList() {
    }

    public LimitedLinkedList(Collection<? extends E> collection) {
        super(collection);
    }

    @Override
    public void addFirst(E e) {
        super.addFirst(e);
        this.ensureMaximumSize();
    }

    private void ensureMaximumSize() {
        while (this.size() > this.sizeMax) {
            if (this.removeFirstElementByExceedingSize) {
                this.removeFirst();
                continue;
            }
            this.removeLast();
        }
    }

    @Override
    public void addLast(E e) {
        super.addLast(e);
        this.ensureMaximumSize();
    }

    @Override
    public boolean add(E e) {
        boolean retval = super.add(e);
        this.ensureMaximumSize();
        return retval;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean retval = super.addAll(c);
        this.ensureMaximumSize();
        return retval;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean retval = super.addAll(index, c);
        this.ensureMaximumSize();
        return retval;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.ensureMaximumSize();
    }

    public void setSizeMax(int sizeMax) {
        this.sizeMax = sizeMax;
        this.ensureMaximumSize();
    }

    public int getSizeMax() {
        return this.sizeMax;
    }

    public boolean isRemoveFirstElementByExceedingSize() {
        return this.removeFirstElementByExceedingSize;
    }

    public void setRemoveFirstElementByExceedingSize(boolean removeFirstElementByExceedingSize) {
        this.removeFirstElementByExceedingSize = removeFirstElementByExceedingSize;
    }
}

