/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list;

import java.io.Serializable;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.IteratorUtils;
import org.omnaest.utils.structure.collection.CollectionAbstract;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.list.adapter.ListToListIteratorAdapter;

public abstract class ListAbstract<E>
extends CollectionAbstract<E>
implements List<E>,
Deque<E>,
Serializable {
    private static final long serialVersionUID = 3410678520148023549L;

    @Override
    public boolean addAll(int index, Collection<? extends E> elementCollection) {
        boolean retval = false;
        if (elementCollection != null) {
            for (E element : elementCollection) {
                if (element == null) continue;
                this.add(index++, element);
                retval = true;
            }
        }
        return retval;
    }

    protected boolean isValidIndex(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListToListIteratorAdapter(this);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListToListIteratorAdapter(this, index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ListAbstractSublist(this, fromIndex, toIndex);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean retval = false;
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public void clear() {
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public void addFirst(E element) {
        boolean index = false;
        this.add(0, element);
    }

    @Override
    public void addLast(E e) {
        this.add(e);
    }

    @Override
    public boolean offerFirst(E element) {
        this.addFirst(element);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        E retval = null;
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        boolean index = false;
        retval = this.remove(0);
        return retval;
    }

    @Override
    public E removeLast() {
        E retval = null;
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int index = this.size() - 1;
        retval = this.remove(index);
        return retval;
    }

    @Override
    public E pollFirst() {
        E retval = null;
        if (!this.isEmpty()) {
            boolean index = false;
            retval = this.remove(0);
        }
        return retval;
    }

    @Override
    public E pollLast() {
        E retval = null;
        if (!this.isEmpty()) {
            int index = this.size() - 1;
            retval = this.remove(index);
        }
        return retval;
    }

    @Override
    public E getFirst() {
        E retval = null;
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        boolean index = false;
        retval = this.get(0);
        return retval;
    }

    @Override
    public E getLast() {
        E retval = null;
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int index = this.size() - 1;
        retval = this.get(index);
        return retval;
    }

    @Override
    public E peekFirst() {
        E retval = null;
        if (!this.isEmpty()) {
            boolean index = false;
            retval = this.get(0);
        }
        return retval;
    }

    @Override
    public E peekLast() {
        E retval = null;
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int index = this.size() - 1;
        retval = this.get(index);
        return retval;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        int index;
        boolean retval = false;
        if (!this.isEmpty() && (index = this.indexOf(o)) >= 0) {
            this.remove(index);
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        int index;
        boolean retval = false;
        if (!this.isEmpty() && (index = this.lastIndexOf(o)) >= 0) {
            this.remove(index);
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E element) {
        this.addFirst(element);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return IteratorUtils.unmodifiableIterator(ListUtils.reverse(this).iterator());
    }

    protected static class ListAbstractSublist<E>
    extends ListAbstract<E> {
        private static final long serialVersionUID = 81960052895916590L;
        protected int fromIndex = -1;
        protected int toIndex = -1;
        protected List<E> parentList = null;

        public ListAbstractSublist(List<E> parentList, int fromIndex, int toIndex) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.parentList = parentList;
        }

        private boolean isParentListNotNull() {
            if (this.parentList == null) {
                throw new NullPointerException("Parental list of sublist is null.");
            }
            return true;
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException("Sublist cannot add new elements.");
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException("Sublist cannot add new elements.");
        }

        @Override
        public E get(int index) {
            E retval = null;
            if (this.isParentListNotNull() && this.isValidIndex(index)) {
                retval = this.parentList.get(this.determineParentListIndexFromCurrentListIndex(index));
            }
            return retval;
        }

        private int determineParentListIndexFromCurrentListIndex(int index) {
            return this.fromIndex + index;
        }

        private int determineCurrentListIndexFromParentListIndex(int index) {
            return index - this.fromIndex;
        }

        @Override
        public int indexOf(Object o) {
            int retval = -1;
            int indexOfWithinParent = this.parentList.indexOf(o);
            if (indexOfWithinParent >= this.fromIndex && indexOfWithinParent < this.toIndex) {
                retval = this.determineCurrentListIndexFromParentListIndex(indexOfWithinParent);
            }
            return retval;
        }

        @Override
        public int lastIndexOf(Object o) {
            int retval = -1;
            int lastIndexOfWithinParent = this.parentList.lastIndexOf(o);
            if (lastIndexOfWithinParent >= this.fromIndex && lastIndexOfWithinParent < this.toIndex) {
                retval = this.determineCurrentListIndexFromParentListIndex(lastIndexOfWithinParent);
            }
            return retval;
        }

        @Override
        public E remove(int index) {
            E retval = null;
            if (this.isParentListNotNull() && this.isValidIndex(index)) {
                this.parentList.remove(this.determineParentListIndexFromCurrentListIndex(index));
                --this.toIndex;
            }
            return retval;
        }

        @Override
        public E set(int index, E element) {
            E retval = null;
            if (this.isParentListNotNull() && this.isValidIndex(index)) {
                this.parentList.set(this.determineParentListIndexFromCurrentListIndex(index), element);
            }
            return retval;
        }

        @Override
        public int size() {
            return Math.max(0, this.toIndex - this.fromIndex);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new ListAbstractSublist<E>(this, fromIndex, toIndex);
        }
    }
}

