/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.collection.list.adapter.ListToListAdapter;
import org.omnaest.utils.structure.collection.list.decorator.LockingListDecorator;
import org.omnaest.utils.structure.collection.list.decorator.LockingListIteratorDecorator;
import org.omnaest.utils.structure.element.ElementStream;
import org.omnaest.utils.structure.element.KeyExtractor;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterElementToMapEntry;
import org.omnaest.utils.structure.element.converter.ElementConverterOneToMany;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.element.filter.ElementFilter;
import org.omnaest.utils.structure.element.filter.ElementFilterIndexPositionBasedForGivenIndexes;
import org.omnaest.utils.structure.element.filter.ElementFilterNotBlank;
import org.omnaest.utils.structure.element.filter.ExcludingElementFilterConstant;
import org.omnaest.utils.structure.element.filter.ExcludingElementFilterIndexPositionBased;
import org.omnaest.utils.structure.element.filter.ExcludingElementFilterNotNull;
import org.omnaest.utils.structure.iterator.IterableUtils;
import org.omnaest.utils.structure.map.MapUtils;

public class ListUtils {
    public static <FROM, TO> List<TO> convert(Collection<FROM> collection, ElementConverter<FROM, TO> elementConverter) {
        ArrayList<TO> retlist = new ArrayList<TO>();
        if (elementConverter != null && collection != null) {
            for (FROM element : collection) {
                TO convertedElement = elementConverter.convert(element);
                retlist.add(convertedElement);
            }
        }
        return retlist;
    }

    public static <FROM, TO> List<TO> convert(ElementConverter<FROM, TO> elementConverter, FROM ... elements) {
        ArrayList<TO> retlist = new ArrayList<TO>();
        if (elementConverter != null && elements != null) {
            for (FROM element : elements) {
                TO convertedElement = elementConverter.convert(element);
                retlist.add(convertedElement);
            }
        }
        return retlist;
    }

    public static <FROM, TO> List<TO> convert(Iterable<FROM> iterable, ElementConverter<FROM, TO> elementConverter) {
        ArrayList<TO> retlist = new ArrayList<TO>();
        if (elementConverter != null && iterable != null) {
            for (FROM element : iterable) {
                TO convertedElement = elementConverter.convert(element);
                retlist.add(convertedElement);
            }
        }
        return retlist;
    }

    public static <FROM, TO> List<TO> convert(Collection<FROM> collection, ElementConverter<FROM, TO> elementConverter, boolean eliminateNullValues) {
        ArrayList<TO> retlist;
        block4: {
            retlist = new ArrayList<TO>();
            if (elementConverter == null || collection == null) break block4;
            if (eliminateNullValues) {
                for (FROM element : collection) {
                    TO convertedElement = elementConverter.convert(element);
                    if (convertedElement == null) continue;
                    retlist.add(convertedElement);
                }
            } else {
                for (FROM element : collection) {
                    TO convertedElement = elementConverter.convert(element);
                    retlist.add(convertedElement);
                }
            }
        }
        return retlist;
    }

    public static <FROM, TO> List<TO> convert(Collection<FROM> collection, ElementConverterOneToMany<FROM, TO> multiElementConverter) {
        return ListUtils.convert(collection, multiElementConverter, false);
    }

    public static <FROM, TO> List<TO> convert(Collection<FROM> collection, ElementConverterOneToMany<FROM, TO> multiElementConverter, boolean eliminateNullValues) {
        ArrayList<TO> retlist = new ArrayList<TO>();
        if (collection != null && multiElementConverter != null) {
            for (FROM element : collection) {
                try {
                    Collection<TO> transformedElementCollection = multiElementConverter.convert(element);
                    if (transformedElementCollection == null) continue;
                    for (TO transformedElement : transformedElementCollection) {
                        if (eliminateNullValues && transformedElement == null) continue;
                        retlist.add(transformedElement);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return retlist;
    }

    public static <FROM, TO> List<TO> convertExcludingNullElements(Collection<FROM> collection, ElementConverter<FROM, TO> elementConverter) {
        return ListUtils.convert(collection, elementConverter, true);
    }

    public static <FROM, TO> List<TO> convertListExcludingNullElements(Collection<FROM> collection, ElementConverterOneToMany<FROM, TO> multiElementConverter) {
        return ListUtils.convert(collection, multiElementConverter, true);
    }

    public static <E> List<E> filter(Collection<E> collection, ElementFilter<E> elementFilter) {
        return ListUtils.filter(collection, elementFilter);
    }

    public static <E> List<E> filter(Iterable<E> iterable, ElementFilter<E> elementFilter) {
        ArrayList<E> retlist = new ArrayList<E>();
        if (iterable != null && elementFilter != null) {
            boolean excludingMode = ElementFilter.FilterMode.EXCLUDING.equals((Object)elementFilter.getFilterMode());
            for (E element : iterable) {
                boolean matchingFilter = elementFilter.filter(element);
                boolean excluded = excludingMode && matchingFilter || !excludingMode && !matchingFilter;
                if (excluded) continue;
                retlist.add(element);
            }
        }
        return retlist;
    }

    public static <E> List<E> filter(List<E> list, ExcludingElementFilterIndexPositionBased elementFilterIndexBased) {
        ArrayList<E> retlist = new ArrayList<E>();
        if (list != null && elementFilterIndexBased != null) {
            for (int index = 0; index < list.size(); ++index) {
                E element = list.get(index);
                if (elementFilterIndexBased.filter(index)) continue;
                retlist.add(element);
            }
        }
        return retlist;
    }

    public static <E> List<E> filterAndOrderBy(Iterable<E> sourceIterable, Iterable<E> ... filterAndOrderProvidingIterables) {
        List<E> retlist = null;
        if (sourceIterable != null) {
            retlist = ListUtils.valueOf(sourceIterable);
            for (Iterable<E> iterable : filterAndOrderProvidingIterables) {
                if (iterable == null) continue;
                HashSet<E> tempSet = new HashSet<E>(retlist);
                retlist = new ArrayList();
                for (E element : iterable) {
                    if (!tempSet.contains(element)) continue;
                    retlist.add(element);
                }
            }
        }
        return retlist;
    }

    public static <E> List<E> filterExcludingElement(Collection<E> collection, E element) {
        return ListUtils.filter(collection, new ExcludingElementFilterConstant<E>(element));
    }

    public static <E> List<E> filterExcludingIndexPositions(List<E> list, Collection<Integer> indexPositionCollection) {
        return ListUtils.filter(list, new ElementFilterIndexPositionBasedForGivenIndexes(indexPositionCollection, ElementFilter.FilterMode.EXCLUDING));
    }

    public static <E> List<E> filterExcludingIndexPositions(List<E> list, int ... indexPositions) {
        return ListUtils.filterExcludingIndexPositions(list, Arrays.asList((Integer[])ArrayUtils.toObject(indexPositions)));
    }

    public static <E> List<E> filterExcludingNullElements(Collection<E> collection) {
        return ListUtils.filter(collection, new ExcludingElementFilterNotNull());
    }

    public static <E> List<String> filterExcludingBlankElements(Collection<String> collection) {
        return ListUtils.filter(collection, new ElementFilterNotBlank());
    }

    public static <E> List<E> filterIncludingIndexPositions(List<E> list, Collection<Integer> indexPositionCollection) {
        return ListUtils.filter(list, new ElementFilterIndexPositionBasedForGivenIndexes(indexPositionCollection, ElementFilter.FilterMode.INCLUDING));
    }

    public static <E> List<E> filterIncludingIndexPositions(List<E> list, Integer ... indexPositions) {
        return ListUtils.filterIncludingIndexPositions(list, Arrays.asList(indexPositions));
    }

    public static <E> List<E> filter(List<E> list, BitSet bitSet) {
        ArrayList<E> retlist = new ArrayList<E>();
        int ii = bitSet.nextSetBit(0);
        while (ii >= 0) {
            retlist.add(list.get(ii));
            ii = bitSet.nextSetBit(ii + 1);
        }
        return retlist;
    }

    public static <E> List<E> valueOf(Iterable<? extends E> iterable) {
        Iterator<E> iterator;
        ArrayList<E> retlist = new ArrayList<E>();
        if (iterable != null && (iterator = iterable.iterator()) != null) {
            while (iterator.hasNext()) {
                E element = iterator.next();
                retlist.add(element);
            }
        }
        return retlist;
    }

    public static <E> List<E> valueOf(Iterator<E> iterator) {
        return ListUtils.valueOf(IterableUtils.valueOf(iterator));
    }

    public static <E> List<E> valueOf(Iterator<E> iterator, int toIndexPosition) {
        boolean fromIndexPosition = false;
        return ListUtils.valueOf(iterator, 0, toIndexPosition);
    }

    public static <E> List<E> valueOf(Iterator<E> iterator, int fromIndexPosition, int toIndexPosition) {
        ArrayList<E> retlist = new ArrayList<E>();
        if (iterator != null) {
            for (int ii = 0; ii < toIndexPosition && iterator.hasNext(); ++ii) {
                E element = iterator.next();
                if (ii < fromIndexPosition) continue;
                retlist.add(element);
            }
        }
        return retlist;
    }

    public static <E> List<E> valueOf(ElementStream<E> elementStream) {
        Iterable<E> iterable = IterableUtils.valueOf(elementStream);
        return ListUtils.valueOf(iterable);
    }

    public static <E> List<E> valueOf(E ... elements) {
        return ListUtils.valueOf(Arrays.asList(elements));
    }

    public static <E> List<Integer> indexListOf(List<E> list, E element) {
        ArrayList<Integer> retlist = new ArrayList<Integer>();
        if (element != null && list != null) {
            for (int ii = 0; ii < list.size(); ++ii) {
                E iElement = list.get(ii);
                if (!element.equals(iElement)) continue;
                retlist.add(ii);
            }
        }
        return retlist;
    }

    public static <E> List<E> intersection(Collection<E> ... collections) {
        ArrayList<E> retlist = new ArrayList<E>();
        if (collections.length > 0) {
            Collection<E> collection = collections[0];
            if (collection != null) {
                retlist.addAll(collection);
            }
            for (int ii = 1; ii < collections.length && !retlist.isEmpty(); ++ii) {
                Collection<E> collectionOther = collections[ii];
                if (collectionOther == null) continue;
                retlist.retainAll(collectionOther);
            }
        }
        return retlist;
    }

    public static <E> List<E> intersection(Collection<? extends Collection<E>> collectionOfCollections) {
        ArrayList<E> retlist = new ArrayList<E>();
        if (!collectionOfCollections.isEmpty()) {
            Iterator<Collection<E>> listCollectionIterator = collectionOfCollections.iterator();
            Collection<E> collection = listCollectionIterator.next();
            if (collection != null) {
                retlist.addAll(collection);
            }
            while (listCollectionIterator.hasNext()) {
                Collection<E> collectionOther = listCollectionIterator.next();
                if (collectionOther == null) continue;
                retlist.retainAll(collectionOther);
            }
        }
        return retlist;
    }

    public static <E> List<E> iterableAsList(Iterable<E> iterable) {
        return iterable == null ? new ArrayList() : ListUtils.iteratorAsList(iterable.iterator());
    }

    public static <E> List<E> iteratorAsList(Iterator<E> iterator) {
        ArrayList<E> retlist = new ArrayList<E>();
        if (iterator != null) {
            while (iterator.hasNext()) {
                retlist.add(iterator.next());
            }
        }
        return retlist;
    }

    public static <E> E lastElementOf(List<E> list) {
        return list == null || list.isEmpty() ? null : (E)list.get(list.size() - 1);
    }

    public static <E> E elementWithReverseIndexPosition(List<E> list, int reverseIndexPosition) {
        return list == null || list.isEmpty() || list.size() - reverseIndexPosition <= 0 ? null : (E)list.get(list.size() - 1 - reverseIndexPosition);
    }

    public static <E> E firstElementOf(List<E> list, int reverseIndexPosition) {
        return list != null && !list.isEmpty() ? (E)list.get(0) : null;
    }

    public static <E> List<E> mergeAll(Collection<? extends Collection<E>> collections) {
        ArrayList<E> retlist = new ArrayList<E>();
        if (collections != null) {
            for (Collection<E> list : collections) {
                retlist.addAll(list);
            }
        }
        return retlist;
    }

    public static <E> List<E> mergeAll(Collection<E> ... collections) {
        return ListUtils.mergeAll(Arrays.asList(collections));
    }

    public static <E> List<E> addToNewList(List<? extends E> list, E ... elements) {
        ArrayList<Object> retlist = new ArrayList<Object>();
        if (list != null) {
            retlist.addAll(list);
        }
        for (E element : elements) {
            retlist.add(element);
        }
        return retlist;
    }

    public static <E> List<E> addToNewList(List<? extends E> list, E element) {
        ArrayList<Object> retlist = new ArrayList<Object>();
        if (list != null) {
            retlist.addAll(list);
        }
        retlist.add(element);
        return retlist;
    }

    public static <E> List<E> add(List<? extends E> list, E element) {
        List<E> retlist = list;
        if (list == null) {
            retlist = new ArrayList<E>();
        }
        retlist.add(element);
        return retlist;
    }

    public static <E> List<E> add(List<? extends E> list, int index, E element) {
        List<Object> retlist = list;
        if (list == null) {
            retlist = new ArrayList<E>();
        }
        while (list.size() < index) {
            list.add(null);
        }
        retlist.add(index, element);
        return retlist;
    }

    public static <E> List<E> addAll(List<? extends E> list, Iterable<? extends E> iterable) {
        ArrayList<E> retlist;
        ArrayList<E> arrayList = retlist = list != null ? list : new ArrayList<E>();
        if (iterable != null) {
            for (E element : iterable) {
                retlist.add(element);
            }
        }
        return retlist;
    }

    public static <E> List<E> addAll(List<? extends E> list, E ... elements) {
        return ListUtils.add(list, elements);
    }

    public static <E> List<E> add(List<? extends E> list, E ... elements) {
        List<E> retlist = list;
        if (list == null) {
            retlist = new ArrayList<E>();
        }
        if (elements != null) {
            for (E element : elements) {
                retlist.add(element);
            }
        }
        return retlist;
    }

    public static <E> List<E> addAll(List<? extends E> list, int index, E ... elements) {
        return ListUtils.add(list, index, elements);
    }

    public static <E> List<E> add(List<? extends E> list, int index, E ... elements) {
        List<Object> retlist = list;
        if (list == null) {
            retlist = new ArrayList<E>();
        }
        while (list.size() < index) {
            list.add(null);
        }
        int relative = 0;
        if (elements != null) {
            for (E element : elements) {
                retlist.add(index + relative, element);
                ++relative;
            }
        }
        return retlist;
    }

    public static <E> List<E> set(List<E> list, int index, E element) {
        ArrayList<Object> retlist;
        ArrayList<Object> arrayList = retlist = list != null ? list : new ArrayList<Object>();
        if (index >= 0) {
            while (index >= list.size()) {
                list.add(null);
            }
            list.set(index, element);
        }
        return retlist;
    }

    public static <K, V, E> Map<K, V> toMap(KeyExtractor<? extends K, V> keyExtractor, Iterable<? extends V> iterable) {
        return MapUtils.valueOf(keyExtractor, iterable);
    }

    public static <K, V, E> Map<K, V> toMap(Iterable<E> iterable, ElementConverterElementToMapEntry<E, K, V> elementToMapEntryTransformer) {
        return MapUtils.valueOf(iterable, elementToMapEntryTransformer);
    }

    public static <E> List<E> locked(List<E> list, Lock lock) {
        return new LockingListDecorator<E>(list, lock);
    }

    public static <E> List<E> lockedByReentrantLock(List<E> list) {
        ReentrantLock lock = new ReentrantLock();
        return ListUtils.locked(list, (Lock)lock);
    }

    public static <E> ListIterator<E> locked(ListIterator<E> listIterator, Lock lock) {
        return new LockingListIteratorDecorator<E>(listIterator, lock);
    }

    public static <E> ListIterator<E> lockedByReentrantLock(ListIterator<E> listIterator) {
        ReentrantLock lock = new ReentrantLock();
        return ListUtils.locked(listIterator, (Lock)lock);
    }

    public static <E> E removeLast(List<E> list) {
        E retval = null;
        if (list != null && !list.isEmpty()) {
            retval = list.remove(list.size() - 1);
        }
        return retval;
    }

    public static <E> E removeFirst(List<E> list) {
        int index = 0;
        return ListUtils.remove(list, index);
    }

    public static <E> List<E> removeFirstToNewList(List<? extends E> list) {
        List<? extends E> retlist = ListUtils.valueOf(list);
        ListUtils.removeFirst(retlist);
        return retlist;
    }

    public static <E> E remove(List<E> list, int index) {
        E retval = null;
        if (list != null && index >= 0 && list.size() > index) {
            retval = list.remove(index);
        }
        return retval;
    }

    public static <E> E firstElement(List<E> list) {
        int index = 0;
        return ListUtils.elementAt(list, index);
    }

    public static <E> E lastElement(List<E> list) {
        int index = list != null ? list.size() - 1 : -1;
        return ListUtils.elementAt(list, index);
    }

    public static <E> E elementAtInverseIndex(List<E> list, int inverseIndex) {
        int index = list != null ? list.size() - 1 - inverseIndex : -1;
        return ListUtils.elementAt(list, index);
    }

    public static <E> E elementAt(List<E> list, int index) {
        E retval = null;
        if (list != null && index >= 0 && list.size() > index) {
            retval = list.get(index);
        }
        return retval;
    }

    public static <E> List<E> max(List<E> list, int maximumSize) {
        ArrayList<E> retlist = new ArrayList<E>();
        if (list != null && maximumSize >= 0) {
            retlist.addAll(list.subList(0, Math.min(list.size(), maximumSize)));
        }
        return retlist;
    }

    public static <E> List<E> reverse(Iterable<E> iterable) {
        List<E> retlist = ListUtils.valueOf(iterable);
        Collections.reverse(retlist);
        return retlist;
    }

    public static <E extends Comparable<E>> List<E> sorted(Collection<E> collection) {
        Comparator<E> comparator = null;
        return ListUtils.sorted(collection, comparator);
    }

    public static <E> List<E> sorted(Collection<E> collection, Comparator<E> comparator) {
        ArrayList<E> retlist;
        ArrayList<E> arrayList = retlist = collection != null ? new ArrayList<E>(collection) : null;
        if (retlist != null) {
            Collections.sort(retlist, comparator);
        }
        return retlist;
    }

    public static <E> List<E> generateList(int numberOfElements, Factory<E> valueFactory) {
        ArrayList<E> retlist = new ArrayList<E>();
        Assert.isNotNull(valueFactory);
        for (int ii = 0; ii < numberOfElements; ++ii) {
            retlist.add(valueFactory.newInstance());
        }
        return retlist;
    }

    public static <E> E[] asArray(List<? extends E> list, Class<E> type) {
        return ArrayUtils.valueOf(list, type);
    }

    public static <FROM, TO> List<TO> adapter(List<FROM> list, ElementBidirectionalConverter<FROM, TO> elementBidirectionalConverter) {
        return new ListToListAdapter<FROM, TO>(list, elementBidirectionalConverter);
    }

    public static <E> E get(List<E> list, int index) {
        E retval = null;
        if (list != null && index >= 0 && index < list.size()) {
            retval = list.get(index);
        }
        return retval;
    }

    public static <E> List<E> emptyList() {
        return new ArrayList();
    }

    public static boolean isListType(Class<?> type) {
        return type != null && List.class.isAssignableFrom(type);
    }
}

