/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list.adapter;

import java.util.List;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.list.ListAbstract;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;

public class ListToListAdapter<FROM, TO>
extends ListAbstract<TO> {
    private static final long serialVersionUID = 8535695705824958430L;
    private final List<FROM> list;
    private final ElementBidirectionalConverter<FROM, TO> elementBidirectionalConverter;

    public ListToListAdapter(List<FROM> list, ElementBidirectionalConverter<FROM, TO> elementBidirectionalConverter) {
        this.list = list;
        this.elementBidirectionalConverter = elementBidirectionalConverter;
        Assert.isNotNull(list, "list must not be null");
        Assert.isNotNull(elementBidirectionalConverter, "elementBidirectionalConverter must not be null");
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean add(TO e) {
        FROM from = this.elementBidirectionalConverter.convertBackwards(e);
        return this.list.add(from);
    }

    @Override
    public TO get(int index) {
        Object to = this.elementBidirectionalConverter.convert(this.list.get(index));
        return to;
    }

    @Override
    public TO set(int index, TO element) {
        FROM convertedElement = this.elementBidirectionalConverter.convertBackwards(element);
        FROM replacedElement = this.list.set(index, convertedElement);
        Object retval = this.elementBidirectionalConverter.convert(replacedElement);
        return retval;
    }

    @Override
    public void add(int index, TO element) {
        FROM from = this.elementBidirectionalConverter.convertBackwards(element);
        this.list.add(index, from);
    }

    @Override
    public TO remove(int index) {
        FROM removedElement = this.list.remove(index);
        Object retval = this.elementBidirectionalConverter.convert(removedElement);
        return retval;
    }

    @Override
    public int indexOf(Object o) {
        try {
            FROM from = this.elementBidirectionalConverter.convertBackwards(o);
            return this.list.indexOf(from);
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        try {
            FROM from = this.elementBidirectionalConverter.convertBackwards(o);
            return this.list.lastIndexOf(from);
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public void clear() {
        this.list.clear();
    }
}

