/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list.decorator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class ListDispatcher<E>
implements List<E> {
    protected final ListDispatchControl<E> listDispatchControl;

    public ListDispatcher(List<E> ... lists) {
        this.listDispatchControl = new ListDispatchControl<E>(lists);
    }

    @Override
    public int size() {
        return this.getList().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getList().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getList().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getList().toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.getList().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.getList().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getList().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.getList().addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.getList().addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getList().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getList().retainAll(c);
    }

    @Override
    public void clear() {
        this.getList().clear();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.getList()).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.getList()).hashCode();
    }

    @Override
    public E get(int index) {
        return this.getList().get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.getList().set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.getList().add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.getList().remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.getList().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.getList().listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.getList().listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    protected List<E> getList() {
        return this.listDispatchControl.getList();
    }

    public String toString() {
        return this.getList().toString();
    }

    protected static class ListDispatchControl<E> {
        private List<List<E>> lists = new ArrayList<List<E>>();
        private int currentListIndex = 0;

        public ListDispatchControl(List<E> ... lists) {
            this.lists.addAll(Arrays.asList(lists));
        }

        public ListDispatchControl<E> switchToNextInternalList() {
            this.currentListIndex = Math.min(this.lists.size() - 1, this.currentListIndex + 1);
            return this;
        }

        public ListDispatchControl<E> switchToPreviousInternalList() {
            this.currentListIndex = Math.max(0, this.currentListIndex - 1);
            return this;
        }

        public ListDispatchControl<E> rolloverToNextList() {
            Object listOld = this.getList();
            this.switchToNextInternalList();
            Object listNew = this.getList();
            if (listOld != listNew) {
                listNew.addAll(listOld);
                listOld.clear();
            }
            return this;
        }

        public ListDispatchControl<E> rolloverToPreviousList() {
            Object listOld = this.getList();
            this.switchToPreviousInternalList();
            Object listNew = this.getList();
            if (listOld != listNew) {
                listNew.addAll(listOld);
                listOld.clear();
            }
            return this;
        }

        public <L extends List<E>> L getList() {
            return (L)this.lists.get(this.currentListIndex);
        }

        public int getCurrentListIndex() {
            return this.currentListIndex;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ListDispatchControl [lists=");
            builder.append(this.lists);
            builder.append(", currentListIndex=");
            builder.append(this.currentListIndex);
            builder.append("]");
            return builder.toString();
        }
    }
}

