/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list.decorator;

import java.util.ListIterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.omnaest.utils.structure.collection.list.decorator.ListIteratorDecorator;

public class LockingListIteratorDecorator<E>
extends ListIteratorDecorator<E> {
    private static final long serialVersionUID = 9184804009754659323L;
    protected final Lock lock;

    public LockingListIteratorDecorator(ListIterator<E> listIterator, Lock lock) {
        super(listIterator);
        this.lock = lock;
    }

    public LockingListIteratorDecorator(ListIterator<E> listIterator) {
        super(listIterator);
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.hasNext();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        E retval = null;
        this.lock.lock();
        try {
            retval = super.next();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPrevious() {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.hasPrevious();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E previous() {
        E retval = null;
        this.lock.lock();
        try {
            retval = super.previous();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextIndex() {
        int retval = 0;
        this.lock.lock();
        try {
            retval = super.nextIndex();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int previousIndex() {
        int retval = 0;
        this.lock.lock();
        try {
            retval = super.previousIndex();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        this.lock.lock();
        try {
            super.remove();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(E e) {
        this.lock.lock();
        try {
            super.set(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(E e) {
        this.lock.lock();
        try {
            super.add(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int retval = 0;
        this.lock.lock();
        try {
            retval = super.hashCode();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        boolean retval = false;
        this.lock.lock();
        try {
            retval = super.equals(obj);
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String retval = null;
        this.lock.lock();
        try {
            retval = super.toString();
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }
}

