/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list.sorted;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.omnaest.utils.structure.collection.list.sorted.SortedList;
import org.omnaest.utils.structure.collection.list.sorted.SortedListAbstract;

public class InsertionSortedList<E>
extends SortedListAbstract<E> {
    private static final long serialVersionUID = -4290221104699140741L;
    protected final List<E> list = this.newInternalList();

    public InsertionSortedList() {
    }

    public InsertionSortedList(Collection<E> collection, Comparator<E> comparator) {
        super(comparator);
        this.addAll(collection);
    }

    public InsertionSortedList(Collection<E> collection) {
        this.addAll(collection);
    }

    public InsertionSortedList(Comparator<E> comparator) {
        super(comparator);
    }

    @Override
    public boolean add(E element) {
        int insertionIndexPosition = Collections.binarySearch(this.list, element, this.comparator);
        if (insertionIndexPosition < 0) {
            insertionIndexPosition = -(insertionIndexPosition + 1);
        }
        this.list.add(insertionIndexPosition, element);
        return true;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public int indexOf(Object object) {
        int retval = -1;
        try {
            Object element = object;
            List<E> list = this.list;
            while (list != null) {
                int indexPosition = Collections.binarySearch(list, element, this.comparator);
                if (indexPosition >= 0) {
                    retval = indexPosition;
                    list = list.subList(0, indexPosition);
                    continue;
                }
                list = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    @Override
    public int lastIndexOf(Object object) {
        int retval = -1;
        try {
            Object element = object;
            List<E> list = this.list;
            int indexPositionDelta = 0;
            while (list != null) {
                int indexPosition = Collections.binarySearch(list, element, this.comparator);
                if (indexPosition >= 0) {
                    retval = indexPositionDelta + indexPosition;
                    list = list.subList(indexPosition + 1, list.size());
                    indexPositionDelta += indexPosition + 1;
                    continue;
                }
                list = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    protected ArrayList<E> newInternalList() {
        return new ArrayList();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    protected SortedList<E> newInstance(Collection<E> collection) {
        return new InsertionSortedList<E>(collection);
    }
}

