/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list.sorted;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.collection.list.ListAbstract;
import org.omnaest.utils.structure.collection.list.sorted.SortedList;
import org.omnaest.utils.structure.collection.list.sorted.SortedSplitableList;

public abstract class SortedListAbstract<E>
extends ListAbstract<E>
implements SortedSplitableList<E> {
    private static final long serialVersionUID = -5663102837607165996L;
    protected final Comparator<E> comparator;

    public SortedListAbstract(Comparator<E> comparator) {
        this.comparator = comparator != null ? comparator : new Comparator<E>(){

            @Override
            public int compare(E element1, E element2) {
                return ((Comparable)element1).compareTo(element2);
            }
        };
    }

    public SortedListAbstract() {
        this(null);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public E first() {
        return SortedListAbstract.first(this);
    }

    protected static <E> E first(SortedList<E> sortedList) {
        return sortedList != null && !sortedList.isEmpty() ? (E)sortedList.get(0) : null;
    }

    @Override
    public E last() {
        return SortedListAbstract.last(this);
    }

    protected static <E> E last(SortedList<E> sortedList) {
        return sortedList != null && !sortedList.isEmpty() ? (E)sortedList.get(sortedList.size() - 1) : null;
    }

    @Override
    public SortedList<E> subList(E fromElement, E toElement) {
        return SortedListAbstract.subList(this, fromElement, toElement);
    }

    @Override
    public SortedList<E> headList(E toElement) {
        return SortedListAbstract.headList(this, toElement);
    }

    @Override
    public SortedList<E> tailList(E fromElement) {
        return SortedListAbstract.tailList(this, fromElement);
    }

    protected static <E> SortedList<E> subList(SortedList<E> list, E fromElement, E toElement) {
        SortedList<E> retlist = null;
        if (list != null) {
            int fromIndex = list.indexOf(fromElement);
            int toIndex = list.indexOf(toElement);
            retlist = list.subList(fromIndex, toIndex);
        }
        return retlist;
    }

    protected static <E> SortedList<E> headList(SortedList<E> list, E toElement) {
        SortedList<E> retlist = null;
        if (list != null) {
            int fromIndex = 0;
            int toIndex = list.indexOf(toElement);
            retlist = list.subList(fromIndex, toIndex);
        }
        return retlist;
    }

    protected static <E> SortedList<E> tailList(SortedList<E> list, E fromElement) {
        SortedList<E> retlist = null;
        if (list != null) {
            int fromIndex = list.indexOf(fromElement);
            int toIndex = list.size();
            retlist = list.subList(fromIndex, toIndex);
        }
        return retlist;
    }

    @Override
    public SortedList<E> subList(int fromIndex, int toIndex) {
        return new SortedListAbstractSublist(this, fromIndex, toIndex);
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
    }

    @Override
    public E set(int index, E element) {
        Object retval = this.remove(index);
        this.add(element);
        return retval;
    }

    @Override
    public SortedList<E> splitAt(int index) {
        SortedList retlist = null;
        ArrayList list = new ArrayList();
        index = Math.max(0, index);
        for (int ii = this.size() - 1; ii >= index; --ii) {
            list.add(0, this.remove(ii));
        }
        retlist = this.newInstance(list);
        return retlist;
    }

    protected SortedList<E> newInstance(Collection<E> collection) {
        Class<?> type = this.getClass();
        SortedList retlist = (SortedList)ReflectionUtils.newInstanceOf(type, new Object[0]);
        retlist.addAll(collection);
        return retlist;
    }

    @Override
    public E getFirst() {
        return this.first();
    }

    @Override
    public E getLast() {
        return this.last();
    }

    protected static class SortedListAbstractSublist<E>
    extends ListAbstract.ListAbstractSublist<E>
    implements SortedList<E> {
        private static final long serialVersionUID = 5214337271801597442L;

        public SortedListAbstractSublist(SortedList<E> parentList, int fromIndex, int toIndex) {
            super(parentList, fromIndex, toIndex);
        }

        @Override
        public Comparator<? super E> comparator() {
            return ((SortedList)this.parentList).comparator();
        }

        @Override
        public SortedList<E> subList(E fromElement, E toElement) {
            return SortedListAbstract.subList(this, fromElement, toElement);
        }

        @Override
        public SortedList<E> subList(int fromIndex, int toIndex) {
            return (SortedList)super.subList(fromIndex, toIndex);
        }

        @Override
        public SortedList<E> headList(E toElement) {
            return SortedListAbstract.headList(this, toElement);
        }

        @Override
        public SortedList<E> tailList(E fromElement) {
            return SortedListAbstract.tailList(this, fromElement);
        }

        @Override
        public E first() {
            return SortedListAbstract.first(this);
        }

        @Override
        public E last() {
            return SortedListAbstract.last(this);
        }

        @Override
        public boolean add(E element) {
            return false;
        }
    }
}

