/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list.sorted;

import java.util.Collection;
import org.omnaest.utils.structure.collection.list.sorted.SortedList;
import org.omnaest.utils.structure.collection.list.sorted.SortedListDispatcher;

public class SortedListDispatcherSizeBased<E>
extends SortedListDispatcher<E> {
    private final int exceedThreshold;
    private final int dropUnderThreshold;

    public SortedListDispatcherSizeBased(SortedList<E> firstList, SortedList<E> secondList, int exceedThreshold, int dropUnderThreshold) {
        super(firstList, secondList);
        this.exceedThreshold = exceedThreshold;
        this.dropUnderThreshold = dropUnderThreshold;
        if (firstList.size() + secondList.size() >= this.exceedThreshold) {
            this.listDispatchControl.rolloverToNextList();
        } else if (!secondList.isEmpty()) {
            firstList.addAll(secondList);
            secondList.clear();
        }
    }

    protected void checkDistributionAfterShrink() {
        if (this.size() <= this.dropUnderThreshold) {
            this.listDispatchControl.rolloverToPreviousList();
        }
    }

    protected void checkDistributionAfterExpansion() {
        if (this.size() >= this.exceedThreshold) {
            this.listDispatchControl.rolloverToNextList();
        }
    }

    @Override
    public SortedList<E> splitAt(int index) {
        SortedList retlist = super.splitAt(index);
        this.checkDistributionAfterShrink();
        return retlist;
    }

    @Override
    public boolean add(E e) {
        boolean retval = super.add(e);
        this.checkDistributionAfterExpansion();
        return retval;
    }

    @Override
    public boolean remove(Object o) {
        boolean retval = super.remove(o);
        this.checkDistributionAfterShrink();
        return retval;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean retval = super.addAll(c);
        this.checkDistributionAfterExpansion();
        return retval;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean retval = super.addAll(index, c);
        this.checkDistributionAfterExpansion();
        return retval;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean retval = super.removeAll(c);
        this.checkDistributionAfterShrink();
        return retval;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean retval = super.retainAll(c);
        this.checkDistributionAfterShrink();
        return retval;
    }

    @Override
    public void clear() {
        super.clear();
        this.checkDistributionAfterShrink();
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.checkDistributionAfterExpansion();
    }

    @Override
    public E remove(int index) {
        Object retval = super.remove(index);
        this.checkDistributionAfterShrink();
        return retval;
    }
}

