/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.list.sorted;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.list.decorator.ListDecorator;
import org.omnaest.utils.structure.collection.list.sorted.SortedList;
import org.omnaest.utils.structure.collection.list.sorted.SortedListAbstract;
import org.omnaest.utils.structure.element.ElementHolder;
import org.omnaest.utils.structure.element.ElementHolderUnmodifiable;
import org.omnaest.utils.structure.element.accessor.AccessorReadable;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.iterator.ChainedListIterator;

public class TreeList<E>
extends SortedListAbstract<E> {
    private static final long serialVersionUID = -3181777537000872260L;
    private final SortedMap<AccessorReadable<E>, ElementList> accessorToElementListMap;

    public TreeList() {
        this(new Factory<SortedMap<AccessorReadable<E>, ElementList>>(){

            @Override
            public SortedMap<AccessorReadable<E>, ElementList> newInstance() {
                Comparator comparator = ComparatorUtils.NATURAL_COMPARATOR;
                return new TreeMap(TreeList.newComparatorForAccessor(comparator));
            }
        });
    }

    public TreeList(final Comparator<E> comparator) {
        this(new Factory<SortedMap<AccessorReadable<E>, ElementList>>(){

            @Override
            public SortedMap<AccessorReadable<E>, ElementList> newInstance() {
                return new TreeMap(TreeList.newComparatorForAccessor(comparator));
            }
        });
    }

    public TreeList(Collection<E> collection) {
        this();
        this.addAll(collection);
    }

    public TreeList(Comparator<E> comparator, Collection<E> collection) {
        this(comparator);
        this.addAll(collection);
    }

    private static <E> Comparator<AccessorReadable<E>> newComparatorForAccessor(final Comparator<E> comparator) {
        return new Comparator<AccessorReadable<E>>(){

            @Override
            public int compare(AccessorReadable<E> accessor1, AccessorReadable<E> accessor2) {
                return comparator.compare(accessor1.getElement(), accessor2.getElement());
            }
        };
    }

    protected TreeList(Factory<SortedMap<AccessorReadable<E>, ElementList>> elementToEqualElementListMapFactory) {
        this.accessorToElementListMap = elementToEqualElementListMapFactory.newInstance();
    }

    private Factory<ElementList> newElementListFactory() {
        return new Factory<ElementList>(){

            @Override
            public ElementList newInstance() {
                return new ElementList();
            }
        };
    }

    @Override
    public int size() {
        int retval = 0;
        for (ElementList elementList : this.accessorToElementListMap.values()) {
            retval += elementList.size();
        }
        return retval;
    }

    @Override
    public boolean add(E element) {
        boolean retval = false;
        if (element != null) {
            ElementHolderUnmodifiable<E> accessor = new ElementHolderUnmodifiable<E>(element);
            ElementList elementList = (ElementList)this.accessorToElementListMap.get(accessor);
            if (elementList == null) {
                elementList = this.newElementListFactory().newInstance();
                elementList.add(element);
                this.accessorToElementListMap.put(elementList, elementList);
            } else {
                elementList.add(element);
            }
            retval = true;
        }
        return retval;
    }

    @Override
    public E get(final int index) {
        final ElementHolder retvalHolder = new ElementHolder();
        ElementVisitor elementVisitor = new ElementVisitor<E>(){

            @Override
            public ElementVisitor.TraversalHint beforeTraversalOfElementList(int indexPosition, int elementListSize, List<E> elementList) {
                ElementVisitor.TraversalHint retval = null;
                if (indexPosition + elementListSize < index) {
                    retval = ElementVisitor.TraversalHint.SKIP_SUBLIST;
                }
                return retval;
            }

            @Override
            public ElementVisitor.TraversalHint visitElement(E element, int indexPosition, List<E> elementList, int subListIndexPosition) {
                ElementVisitor.TraversalHint retval = null;
                if (indexPosition == index) {
                    retvalHolder.setElement(element);
                    retval = ElementVisitor.TraversalHint.CANCEL_TRAVERSAL;
                }
                return retval;
            }
        };
        this.visitElements(elementVisitor);
        return retvalHolder.getElement();
    }

    protected void visitElements(ElementVisitor<E> elementVisitor) {
        Collection<ElementList> elementListCollection = this.accessorToElementListMap.values();
        this.visitElements(elementVisitor, elementListCollection);
    }

    protected void visitElements(ElementVisitor<E> elementVisitor, Iterable<ElementList> elementListCollection) {
        ElementList elementList;
        int elementListSize;
        ElementVisitor.TraversalHint traversalHint;
        int indexPosition = -1;
        Iterator<ElementList> i$ = elementListCollection.iterator();
        block0: while (i$.hasNext() && !ElementVisitor.TraversalHint.CANCEL_TRAVERSAL.equals((Object)(traversalHint = elementVisitor.beforeTraversalOfElementList(indexPosition, elementListSize = (elementList = i$.next()).size(), elementList)))) {
            if (ElementVisitor.TraversalHint.SKIP_SUBLIST.equals((Object)traversalHint)) {
                indexPosition += elementListSize;
                continue;
            }
            int elementListIndexPosition = -1;
            for (Object element : elementList) {
                traversalHint = elementVisitor.visitElement(element, ++indexPosition, elementList, ++elementListIndexPosition);
                if (!ElementVisitor.TraversalHint.CANCEL_TRAVERSAL.equals((Object)traversalHint)) continue;
                break block0;
            }
        }
    }

    @Override
    public E remove(final int index) {
        final ElementHolder retvalHolder = new ElementHolder();
        ElementVisitor elementVisitor = new ElementVisitor<E>(){

            @Override
            public ElementVisitor.TraversalHint beforeTraversalOfElementList(int indexPosition, int elementListSize, List<E> elementList) {
                ElementVisitor.TraversalHint retval = null;
                if (indexPosition + elementListSize >= index) {
                    int subListIndexPosition = index - (indexPosition + 1);
                    retvalHolder.setElement(elementList.remove(subListIndexPosition));
                    retval = ElementVisitor.TraversalHint.CANCEL_TRAVERSAL;
                }
                return retval;
            }

            @Override
            public ElementVisitor.TraversalHint visitElement(E element, int indexPosition, List<E> elementList, int subListIndexPosition) {
                return null;
            }
        };
        this.visitElements(elementVisitor);
        return retvalHolder.getElement();
    }

    @Override
    public int indexOf(final Object object) {
        final ElementHolder<Integer> retvalHolder = new ElementHolder<Integer>(-1);
        ElementVisitor elementVisitor = new ElementVisitor<E>(){

            @Override
            public ElementVisitor.TraversalHint beforeTraversalOfElementList(int indexPosition, int elementListSize, List<E> elementList) {
                return elementList.contains(object) ? ElementVisitor.TraversalHint.GO_ON : ElementVisitor.TraversalHint.SKIP_SUBLIST;
            }

            @Override
            public ElementVisitor.TraversalHint visitElement(E element, int indexPosition, List<E> elementList, int subListIndexPosition) {
                ElementVisitor.TraversalHint retval = null;
                if (ObjectUtils.equals((Object)object, element)) {
                    retvalHolder.setElement((Object)indexPosition);
                    retval = ElementVisitor.TraversalHint.CANCEL_TRAVERSAL;
                }
                return retval;
            }
        };
        this.visitElements(elementVisitor);
        return (Integer)retvalHolder.getElement();
    }

    @Override
    public int lastIndexOf(final Object object) {
        final ElementHolder<Integer> retvalHolder = new ElementHolder<Integer>(-1);
        ElementVisitor elementVisitor = new ElementVisitor<E>(){
            private boolean hasAlreadyFoundEqualElement = false;

            @Override
            public ElementVisitor.TraversalHint beforeTraversalOfElementList(int indexPosition, int elementListSize, List<E> elementList) {
                return elementList.contains(object) || this.hasAlreadyFoundEqualElement ? ElementVisitor.TraversalHint.GO_ON : ElementVisitor.TraversalHint.SKIP_SUBLIST;
            }

            @Override
            public ElementVisitor.TraversalHint visitElement(E element, int indexPosition, List<E> elementList, int subListIndexPosition) {
                ElementVisitor.TraversalHint retval = null;
                if (ObjectUtils.equals((Object)object, element)) {
                    this.hasAlreadyFoundEqualElement = true;
                    retvalHolder.setElement((Object)indexPosition);
                } else if (this.hasAlreadyFoundEqualElement) {
                    retval = ElementVisitor.TraversalHint.CANCEL_TRAVERSAL;
                }
                return retval;
            }
        };
        this.visitElements(elementVisitor);
        return (Integer)retvalHolder.getElement();
    }

    @Override
    public boolean remove(Object object) {
        boolean retval = false;
        ElementHolder<Object> accessor = new ElementHolder<Object>(object);
        if (this.accessorToElementListMap.containsKey(accessor)) {
            ElementList elementList = (ElementList)this.accessorToElementListMap.get(accessor);
            elementList.remove(object);
        }
        return retval;
    }

    @Override
    public boolean contains(Object object) {
        boolean retval = false;
        ElementHolder<Object> accessor = new ElementHolder<Object>(object);
        if (this.accessorToElementListMap.containsKey(accessor)) {
            retval = ((ElementList)this.accessorToElementListMap.get(accessor)).contains(object);
        }
        return retval;
    }

    @Override
    public boolean isEmpty() {
        return this.accessorToElementListMap.isEmpty();
    }

    @Override
    public void clear() {
        this.accessorToElementListMap.clear();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ChainedListIterator(this.accessorToElementListMap.values().toArray(new List[0]));
    }

    @Override
    protected SortedList<E> newInstance(Collection<E> collection) {
        return new TreeList<E>(collection);
    }

    protected class ElementList
    extends ListDecorator<E>
    implements AccessorReadable<E> {
        private static final long serialVersionUID = 3764571149202052105L;
        private AccessorReadable<E> accessorReadable;

        public ElementList() {
            super(new ArrayList());
            this.accessorReadable = new AccessorReadable<E>(){

                @Override
                public E getElement() {
                    return ElementList.this.getFirstElement();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            Object element = this.getFirstElement();
            boolean retval = super.remove(o);
            this.removeFromAccessorToElementListMapIfThisListIsEmpty(element);
            return retval;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Object element = this.getFirstElement();
            boolean retval = super.removeAll(c);
            this.removeFromAccessorToElementListMapIfThisListIsEmpty(element);
            return retval;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Object element = this.getFirstElement();
            boolean retval = super.retainAll(c);
            this.removeFromAccessorToElementListMapIfThisListIsEmpty(element);
            return retval;
        }

        @Override
        public E remove(int index) {
            Object retval = super.remove(index);
            this.removeFromAccessorToElementListMapIfThisListIsEmpty(retval);
            return retval;
        }

        protected E getFirstElement() {
            return ListUtils.firstElement(this);
        }

        private void removeFromAccessorToElementListMapIfThisListIsEmpty(E element) {
            if (this.isEmpty()) {
                this.accessorReadable = new ElementHolderUnmodifiable(element);
                TreeList.this.accessorToElementListMap.remove(this);
            }
        }

        @Override
        public E getElement() {
            return this.accessorReadable.getElement();
        }

        @Override
        public void clear() {
            Object element = this.getFirstElement();
            super.clear();
            this.removeFromAccessorToElementListMapIfThisListIsEmpty(element);
        }
    }

    protected static interface ElementVisitor<E> {
        public TraversalHint beforeTraversalOfElementList(int var1, int var2, List<E> var3);

        public TraversalHint visitElement(E var1, int var2, List<E> var3, int var4);

        public static enum TraversalHint {
            GO_ON,
            SKIP_SUBLIST,
            CANCEL_TRAVERSAL;

        }
    }
}

