/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.set;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.omnaest.utils.structure.collection.set.SetUtils;

public class ReducedSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = -5990986312499631525L;
    private Iterable<Set<E>> reductionSets;
    private Set<E> set;

    public ReducedSet(Set<E> set, Iterable<Set<E>> reductionSets) {
        this.set = set;
        this.reductionSets = reductionSets;
    }

    private Set<E> getReducedSet() {
        return SetUtils.delta(this.set, SetUtils.mergeAll(this.reductionSets)).getRemovedElementSet();
    }

    @Override
    public int size() {
        return this.getReducedSet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getReducedSet().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getReducedSet().contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.getReducedSet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getReducedSet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getReducedSet().toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.getReducedSet().add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.getReducedSet().remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getReducedSet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.getReducedSet().addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.getReducedSet().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.getReducedSet().removeAll(c);
    }

    @Override
    public void clear() {
        this.getReducedSet().clear();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.getReducedSet()).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.getReducedSet()).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReducedSet [getReducedSet()=");
        builder.append(this.getReducedSet());
        builder.append("]");
        return builder.toString();
    }
}

