/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.set;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.ReducedSet;
import org.omnaest.utils.structure.collection.set.SetAbstract;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.iterator.IteratorUtils;

public class SetComposite<E>
extends SetAbstract<E> {
    private static final long serialVersionUID = 4042018600715370368L;
    private final Set<E>[] sets;

    public SetComposite(Set<E> ... sets) {
        this.sets = sets;
    }

    public SetComposite(Collection<Set<E>> setCollection) {
        Assert.isNotNull(setCollection, "The given collection of sets must not be null");
        this.sets = setCollection.toArray(new Set[setCollection.size()]);
    }

    @Override
    public int size() {
        int retval = 0;
        for (Set<E> set : this.determineReducedSetList()) {
            if (set == null) continue;
            retval += set.size();
        }
        return retval;
    }

    @Override
    public boolean contains(Object o) {
        boolean retval = false;
        for (Set<E> set : this.sets) {
            if (set == null || !set.contains(o)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    @Override
    public Iterator<E> iterator() {
        List<Set<E>> reducedSetList = this.determineReducedSetList();
        return IteratorUtils.chained(ListUtils.convert(reducedSetList, new ElementConverter<Set<E>, Iterator<E>>(){

            @Override
            public Iterator<E> convert(Set<E> set) {
                return set != null ? set.iterator() : null;
            }
        }));
    }

    private List<Set<E>> determineReducedSetList() {
        ArrayList<Set<ReducedSet<E>>> reducedSetList = new ArrayList<Set<ReducedSet<E>>>();
        if (this.sets != null) {
            for (Set<E> set : this.sets) {
                ArrayList<Set<E>> reductionSetList = new ArrayList<Set<E>>(reducedSetList);
                reducedSetList.add(new ReducedSet<E>(set, reductionSetList));
            }
        }
        return reducedSetList;
    }

    @Override
    public boolean add(E e) {
        boolean retval = false;
        Set<E> currentSet = null;
        int currentSize = Integer.MAX_VALUE;
        for (Set<E> set : this.sets) {
            int size = set.size();
            if (size >= currentSize) continue;
            currentSet = set;
            currentSize = size;
        }
        if (currentSet != null) {
            retval = currentSet.add(e);
        }
        return retval;
    }

    @Override
    public boolean remove(Object o) {
        boolean retval = false;
        for (Set<E> set : this.sets) {
            if (set == null) continue;
            retval |= set.remove(o);
        }
        return retval;
    }
}

