/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.set;

import java.util.Collections;
import java.util.Set;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.structure.element.factory.concrete.HashSetFactory;

public class SetDelta<E> {
    private final Set<E> addedElementSet;
    private final Set<E> removedElementSet;
    private final Set<E> intersection;

    public SetDelta(Set<E> firstSet, Set<E> secondSet) {
        firstSet = ObjectUtils.defaultIfNull(firstSet, new HashSetFactory());
        secondSet = ObjectUtils.defaultIfNull(secondSet, new HashSetFactory());
        this.intersection = SetUtils.intersection(firstSet, secondSet);
        this.addedElementSet = SetUtils.removeAllAsNewSet(secondSet, this.intersection);
        this.removedElementSet = SetUtils.removeAllAsNewSet(firstSet, this.intersection);
    }

    public Set<E> getAddedElementSet() {
        return Collections.unmodifiableSet(this.addedElementSet);
    }

    public Set<E> getRemovedElementSet() {
        return Collections.unmodifiableSet(this.removedElementSet);
    }

    public Set<E> getRetainedElementSet() {
        return Collections.unmodifiableSet(this.intersection);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SetDelta [addedElementSet=");
        builder.append(this.addedElementSet);
        builder.append(", removedElementSet=");
        builder.append(this.removedElementSet);
        builder.append(", intersection=");
        builder.append(this.intersection);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addedElementSet == null ? 0 : ((Object)this.addedElementSet).hashCode());
        result = 31 * result + (this.intersection == null ? 0 : ((Object)this.intersection).hashCode());
        result = 31 * result + (this.removedElementSet == null ? 0 : ((Object)this.removedElementSet).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetDelta)) {
            return false;
        }
        SetDelta other = (SetDelta)obj;
        if (this.addedElementSet == null ? other.addedElementSet != null : !((Object)this.addedElementSet).equals(other.addedElementSet)) {
            return false;
        }
        if (this.intersection == null ? other.intersection != null : !((Object)this.intersection).equals(other.intersection)) {
            return false;
        }
        return !(this.removedElementSet == null ? other.removedElementSet != null : !((Object)this.removedElementSet).equals(other.removedElementSet));
    }
}

