/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.set;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.list.adapter.ListToSetAdapter;
import org.omnaest.utils.structure.collection.set.SetComposite;
import org.omnaest.utils.structure.collection.set.SetDelta;
import org.omnaest.utils.structure.collection.set.adapter.SetToSetAdapter;
import org.omnaest.utils.structure.collection.set.decorator.LockingSetDecorator;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.filter.ElementFilter;
import org.omnaest.utils.structure.iterator.IterableUtils;

public class SetUtils {
    public static <E> SetDelta<E> delta(Set<E> firstSet, Set<E> secondSet) {
        return new SetDelta<E>(firstSet, secondSet);
    }

    public static <E> Set<E> removeAll(Set<E> set, Iterable<? extends E> removingIterable) {
        Set<E> retset = set;
        if (retset != null && removingIterable != null) {
            for (E element : removingIterable) {
                retset.remove(element);
            }
        }
        return retset;
    }

    public static <E> Set<E> remove(Set<E> set, E element) {
        Set<E> retset = set;
        if (retset != null) {
            retset.remove(element);
        }
        return retset;
    }

    public static <E> Set<E> removeAllAsNewSet(Set<E> set, Iterable<E> removingIterable) {
        return SetUtils.removeAll(SetUtils.valueOf(set), removingIterable);
    }

    public static <E> Set<E> add(Set<E> set, E ... elements) {
        LinkedHashSet<E> retset;
        LinkedHashSet<E> linkedHashSet = retset = set != null ? set : new LinkedHashSet<E>();
        if (elements != null) {
            for (E element : elements) {
                retset.add(element);
            }
        }
        return retset;
    }

    public static <E> Set<E> addAll(Set<? extends E> set, Iterable<? extends E> elementIterable) {
        LinkedHashSet<E> retset;
        LinkedHashSet<E> linkedHashSet = retset = set != null ? set : new LinkedHashSet<E>();
        if (elementIterable != null) {
            for (E element : elementIterable) {
                retset.add(element);
            }
        }
        return retset;
    }

    public static <E> Set<E> retainAll(Set<E> set, Collection<? extends E> retainableCollection) {
        Set<E> retset = set;
        if (retset != null) {
            if (retainableCollection != null) {
                retset.retainAll(retainableCollection);
            } else {
                retset.clear();
            }
        }
        return retset;
    }

    public static <E> Set<E> mergeAll(Collection<E> ... collections) {
        return SetUtils.mergeAll(Arrays.asList(collections));
    }

    public static <E> Set<E> mergeAll(Collection<? extends Collection<E>> collectionOfCollections) {
        return new LinkedHashSet(ListUtils.mergeAll(collectionOfCollections));
    }

    public static <E> Set<E> mergeAll(Iterable<? extends Collection<E>> iterableOfCollections) {
        LinkedHashSet<E> retset = new LinkedHashSet<E>();
        if (iterableOfCollections != null) {
            for (Collection<E> collection : iterableOfCollections) {
                if (collection == null) continue;
                for (E element : collection) {
                    retset.add(element);
                }
            }
        }
        return retset;
    }

    public static <E> Set<E> intersection(Collection<? extends Collection<E>> collectionOfCollections) {
        LinkedHashSet<E> retset = new LinkedHashSet<E>();
        if (!collectionOfCollections.isEmpty()) {
            Iterator<Collection<E>> collectionOfCollectionsIterator = collectionOfCollections.iterator();
            Collection<E> collection = collectionOfCollectionsIterator.next();
            if (collection != null) {
                retset.addAll(collection);
            }
            while (collectionOfCollectionsIterator.hasNext()) {
                Collection<E> collectionOther = collectionOfCollectionsIterator.next();
                if (collectionOther == null) continue;
                retset.retainAll(collectionOther);
            }
        }
        return retset;
    }

    public static <E> Set<E> intersection(Set<E> set1, Set<E> set2) {
        LinkedHashSet retset = new LinkedHashSet();
        if (set1 != null && set2 != null) {
            Set<E> iterable;
            Set<E> collection;
            if (set1.size() > set2.size()) {
                collection = set1;
                iterable = set2;
            } else {
                collection = set2;
                iterable = set1;
            }
            for (Object element : iterable) {
                if (!collection.contains(element)) continue;
                retset.add(element);
            }
        }
        return retset;
    }

    public static <E> Set<E> intersection(Collection<E> ... collections) {
        LinkedHashSet<E> retset = new LinkedHashSet<E>();
        if (collections.length > 0) {
            Collection<E> collection = collections[0];
            if (collection != null) {
                retset.addAll(collection);
            }
            for (int ii = 1; ii < collections.length && !retset.isEmpty(); ++ii) {
                Collection<E> collectionOther = collections[ii];
                if (collectionOther == null) continue;
                retset.retainAll(collectionOther);
            }
        }
        return retset;
    }

    public static <E> Set<E> intersection(Collection<E> collectionFirst, Collection<E> collectionSecond) {
        return SetUtils.intersection(Arrays.asList(collectionFirst, collectionSecond));
    }

    public static <E> Set<E> valueOf(E ... elements) {
        LinkedHashSet<E> retset = new LinkedHashSet<E>();
        if (elements != null) {
            for (E element : elements) {
                retset.add(element);
            }
        }
        return retset;
    }

    public static <E> Set<E> emptySet() {
        return new LinkedHashSet();
    }

    public static <E> Set<E> valueOf(Iterator<E> iterator) {
        return SetUtils.valueOf(IterableUtils.valueOf(iterator));
    }

    public static <E> Set<E> valueOf(Iterable<E> iterable) {
        LinkedHashSet<E> retset = new LinkedHashSet<E>();
        if (iterable != null) {
            for (E element : iterable) {
                retset.add(element);
            }
        }
        return retset;
    }

    public static <E> Set<E> locked(Set<E> set, Lock lock) {
        return new LockingSetDecorator<E>(set, lock);
    }

    public static <E> Set<E> lockedByReentrantLock(Set<E> set) {
        ReentrantLock lock = new ReentrantLock();
        return SetUtils.locked(set, lock);
    }

    public static <FROM, TO> Set<TO> convert(ElementConverter<FROM, TO> elementConverter, FROM ... elements) {
        return SetUtils.convert(SetUtils.valueOf(elements), elementConverter);
    }

    public static <FROM, TO> Set<TO> convert(Iterable<FROM> iterable, ElementConverter<FROM, TO> elementConverter) {
        return new LinkedHashSet<TO>(ListUtils.convert(iterable, elementConverter));
    }

    public static <E> Set<E> filter(Iterable<E> iterable, ElementFilter<E> elementFilter) {
        return SetUtils.valueOf(ListUtils.filter(iterable, elementFilter));
    }

    public static <FROM, TO> Set<TO> adapter(Set<FROM> set, ElementBidirectionalConverter<FROM, TO> elementBidirectionalConverter) {
        return new SetToSetAdapter<FROM, TO>(set, elementBidirectionalConverter);
    }

    public static <E> Set<E> adapter(List<E> list) {
        return new ListToSetAdapter<E>(list);
    }

    public static <E> Set<E> composite(Set<E> ... sets) {
        return new SetComposite<E>(sets);
    }

    public static <E> Set<E> composite(Collection<Set<E>> setCollection) {
        return new SetComposite<E>(setCollection);
    }

    public static boolean isSetType(Class<?> type) {
        boolean retval = false;
        if (type != null) {
            retval = Set.class.isAssignableFrom(type);
        }
        return retval;
    }

    public static boolean isSortedSetType(Class<?> type) {
        boolean retval = false;
        if (type != null) {
            retval = SortedSet.class.isAssignableFrom(type);
        }
        return retval;
    }
}

