/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.collection.set.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.structure.collection.set.SetAbstract;

public class MapBasedSet<E>
extends SetAbstract<E> {
    private static final long serialVersionUID = 59020838477262671L;
    private static final Object MARKER_VALUE = new Object();
    private final Map<E, Object> map;

    public MapBasedSet(Map<E, Object> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, MARKER_VALUE) != null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.map.keySet().containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.map.keySet().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.map.keySet().retainAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    private Set<E> keySet() {
        return this.map.keySet();
    }

    @Override
    public String toString() {
        return String.valueOf(this.keySet());
    }
}

