/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.container;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.download.DownloadConnection;
import org.omnaest.utils.download.URIHelper;
import org.omnaest.utils.download.URLHelper;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.streams.StreamConnector;

public class ByteArrayContainer {
    public static final String ENCODING_UTF8 = "utf-8";
    public static final String DEFAULTENCODING = "utf-8";
    public static final String DEFAULTZIPFILENAME = "data.dat";
    private byte[] content = null;
    private boolean isContentInvalid = false;
    private ExceptionHandler exceptionHandler = null;
    public static Class<? extends ByteArrayContainer> implementationForByteArrayContainerClass = ByteArrayContainer.class;

    public ByteArrayContainer() {
    }

    public ByteArrayContainer(byte[] content) {
        this();
        this.copyFrom(content);
    }

    public ByteArrayContainer(String content) {
        this();
        this.copyFrom(content);
    }

    public ByteArrayContainer(String content, String encoding) {
        this();
        this.copyFrom(content, encoding);
    }

    public ByteArrayContainer(CharSequence charsequence, String encoding) {
        this();
        this.copyFrom(charsequence, encoding);
    }

    public ByteArrayContainer(InputStream sourceInputStream) {
        this();
        this.copyFrom(sourceInputStream);
    }

    public ByteArrayContainer(CharSequence charsequence) {
        this();
        this.copyFrom(charsequence);
    }

    public ByteArrayContainer(Readable readable) {
        this();
        this.copyFrom(readable);
    }

    public boolean isEmpty() {
        return this.content == null || this.content.length == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public void download(URI uri) {
        this.download(URIHelper.getURLfromURI(uri));
    }

    public void download(URL url) {
        if (url != null) {
            DownloadConnection downloadConnection = new DownloadConnection();
            downloadConnection.download(url);
            this.copyFrom(downloadConnection.getContentAsBytes());
        } else {
            this.clear();
        }
    }

    public void download(String urlStr) {
        this.download(URLHelper.createURL(urlStr));
    }

    @Deprecated
    public void load(File file) {
        this.copyFrom(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayContainer copyFrom(File file) {
        this.setContentInvalid(true);
        this.clear();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                StreamConnector.connect(bufferedInputStream, byteArrayOutputStream);
                bufferedInputStream.close();
            }
            finally {
                fileInputStream.close();
                byteArrayOutputStream.close();
            }
            this.content = byteArrayOutputStream.toByteArray();
            this.setContentInvalid(false);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }

    private void handleException(Exception e) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handleException(e);
        }
    }

    @Deprecated
    public void save(File file) {
        this.writeTo(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                try {
                    bufferedOutputStream.write(this.content);
                    bufferedOutputStream.flush();
                }
                finally {
                    bufferedOutputStream.close();
                }
                fileOutputStream.flush();
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public ByteArrayContainer copyFrom(ByteArrayContainer sourceByteArrayContainer) {
        this.copyFrom(sourceByteArrayContainer.getInputStream());
        return this;
    }

    public ByteArrayContainer copyFrom(InputStream sourceInputStream) {
        this.isContentInvalid = true;
        this.clear();
        try {
            Assert.isNotNull((Object)sourceInputStream, "sourceInputStream must not be null");
            OutputStream outputStream = this.getOutputStream();
            StreamConnector.connect(sourceInputStream, outputStream);
            outputStream.close();
            this.isContentInvalid = false;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayContainer copyFrom(URL url) {
        this.isContentInvalid = true;
        this.clear();
        InputStream sourceInputStream = null;
        try {
            Assert.isNotNull((Object)url, "url must not be null");
            sourceInputStream = url.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(sourceInputStream);
            this.copyFrom(bufferedInputStream);
            bufferedInputStream.close();
            this.isContentInvalid = false;
        }
        catch (IOException e) {
            this.handleException(e);
        }
        finally {
            try {
                sourceInputStream.close();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayContainer copyFrom(URLConnection urlConnection) {
        this.isContentInvalid = true;
        this.clear();
        InputStream sourceInputStream = null;
        try {
            Assert.isNotNull((Object)urlConnection, "urlConnection must not be null");
            sourceInputStream = urlConnection.getInputStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(sourceInputStream);
            this.copyFrom(bufferedInputStream);
            bufferedInputStream.close();
            this.isContentInvalid = true;
        }
        catch (IOException e) {
            this.handleException(e);
        }
        finally {
            try {
                sourceInputStream.close();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return this;
    }

    public ByteArrayContainer copyFrom(Readable readable) {
        return this.copyFrom(readable, "utf-8");
    }

    public ByteArrayContainer copyFrom(Readable readable, String encoding) {
        this.isContentInvalid = false;
        if (readable != null) {
            encoding = StringUtils.defaultString((String)encoding, (String)"utf-8");
            try {
                StringBuffer stringBuffer = new StringBuffer();
                CharBuffer charBuffer = CharBuffer.wrap(new char[1000]);
                int read = 0;
                while (read >= 0) {
                    charBuffer.clear();
                    read = readable.read(charBuffer);
                    charBuffer.flip();
                    if (read <= 0) continue;
                    stringBuffer.append(charBuffer, 0, read);
                }
                this.copyFrom(stringBuffer, encoding);
            }
            catch (IOException e) {
                this.isContentInvalid = true;
                this.handleException(e);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayContainer copyFrom(String string, String encoding) {
        this.isContentInvalid = true;
        try {
            OutputStream outputStream = this.getOutputStream();
            try {
                OutputStreamWriter osw = new OutputStreamWriter(outputStream, encoding);
                osw.write(string);
                osw.close();
                this.isContentInvalid = false;
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return this;
    }

    public ByteArrayContainer copyFrom(String string) {
        this.copyFrom(string, "utf-8");
        return this;
    }

    public ByteArrayContainer copyFrom(CharSequence charSequence) {
        this.copyFrom(charSequence, "utf-8");
        return this;
    }

    public ByteArrayContainer copyFrom(CharSequence charSequence, String encoding) {
        this.copyFrom(((Object)charSequence).toString(), "utf-8");
        return this;
    }

    public ByteArrayContainer copyFrom(byte[] source) {
        ByteArrayInputStream bis = new ByteArrayInputStream(source);
        this.copyFrom(bis);
        return this;
    }

    public <S extends Serializable> ByteArrayContainer copyFromAsSerialized(S element) {
        byte[] content = element != null ? SerializationUtils.serialize(element) : null;
        this.setContent(content);
        return this;
    }

    public <S extends Serializable> S toDeserializedElement() {
        return (S)(this.content != null ? (Serializable)SerializationUtils.deserialize((byte[])this.content) : null);
    }

    public String toString() {
        return this.toString("utf-8");
    }

    public String toString(String encoding) {
        String retval = null;
        try {
            StringBuffer sb = new StringBuffer();
            StreamConnector.connect(this.getInputStream(), sb, encoding);
            retval = sb.toString();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return retval;
    }

    public List<String> toStringList() {
        return this.toStringList("utf-8");
    }

    public List<String> toStringList(String encoding) {
        String regExDelimiter = "[\r\n]+";
        return this.toStringList(encoding, "[\r\n]+");
    }

    public List<String> toStringList(String encoding, String regExDelimiter) {
        ArrayList<String> retlist = new ArrayList<String>();
        String content = this.toString(encoding);
        String tokenDelimiter = "\u00b0}>|<{\u00b0";
        content = content.replaceAll(regExDelimiter, "\u00b0}>|<{\u00b0");
        Object[] lines = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)content, (String)"\u00b0}>|<{\u00b0");
        CollectionUtils.addAll(retlist, (Object[])lines);
        return retlist;
    }

    public boolean writeTo(Writer writer, String encoding) {
        boolean retval = true;
        if (writer != null) {
            try {
                writer.write(this.toString(encoding));
                writer.flush();
            }
            catch (IOException e) {
                retval = false;
                this.handleException(e);
            }
        }
        return retval;
    }

    public boolean writeTo(Writer writer) {
        return this.writeTo(writer, "utf-8");
    }

    public boolean writeTo(Appendable appendable, String encoding) {
        boolean retval = true;
        try {
            StringBuffer sb = new StringBuffer();
            StreamConnector.connect(this.getInputStream(), sb, encoding);
            appendable.append(sb);
        }
        catch (IOException e) {
            retval = false;
            this.handleException(e);
        }
        return retval;
    }

    public boolean writeTo(OutputStream outputStream) {
        return StreamConnector.transfer(this.getInputStream(), outputStream).isSuccessful();
    }

    public void clear() {
        this.setContent(null);
    }

    public byte[] getContent() {
        return this.content;
    }

    public ByteArrayContainer setContent(byte[] content) {
        this.content = content;
        return this;
    }

    public InputStream getInputStream() {
        ByteArrayInputStream is = null;
        if (this.content != null) {
            is = new ByteArrayInputStream(this.content);
        }
        return is;
    }

    public Reader getReader() {
        return this.getReader("utf-8");
    }

    public Reader getReader(String encoding) {
        InputStreamReader retval = null;
        try {
            retval = new InputStreamReader(this.getInputStream(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
        }
        return retval;
    }

    public OutputStream getOutputStream() {
        return new ByteArrayOutputStream(0){

            @Override
            public void close() {
                block2: {
                    try {
                        super.close();
                    }
                    catch (IOException e) {
                        if (ByteArrayContainer.this.exceptionHandler == null) break block2;
                        ByteArrayContainer.this.exceptionHandler.handleException(e);
                    }
                }
                ByteArrayContainer.access$102(ByteArrayContainer.this, this.toByteArray());
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                ByteArrayContainer.access$102(ByteArrayContainer.this, this.toByteArray());
            }
        };
    }

    public OutputStreamWriter getOutputStreamWriter(String encoding) {
        OutputStreamWriter retval = null;
        try {
            retval = new OutputStreamWriter(this.getOutputStream(), encoding);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return retval;
    }

    public OutputStreamWriter getOutputStreamWriter() {
        return this.getOutputStreamWriter("utf-8");
    }

    public void zip(String zipFileName) {
        if (StringUtils.isNotBlank((CharSequence)zipFileName)) {
            HashMap<String, ByteArrayContainer> byteArrayContainerMap = new HashMap<String, ByteArrayContainer>();
            byteArrayContainerMap.put(zipFileName, this);
            ByteArrayContainer tempByteArrayContainer = ByteArrayContainer.zipFilenameByteArrayContainerMap(byteArrayContainerMap);
            if (tempByteArrayContainer != null) {
                this.content = tempByteArrayContainer.content;
            }
        }
    }

    public void zip() {
        this.zip(ByteArrayContainer.generateRandomDefaultFileName());
    }

    public static ByteArrayContainer zipFilenameByteArrayContainerMap(Map<String, ByteArrayContainer> byteArrayContainerMap) {
        ExceptionHandler exceptionHandler = null;
        return ByteArrayContainer.zipFilenameByteArrayContainerMap(byteArrayContainerMap, exceptionHandler);
    }

    public static ByteArrayContainer zipFilenameByteArrayContainerMap(Map<String, ByteArrayContainer> byteArrayContainerMap, ExceptionHandler exceptionHandler) {
        ByteArrayContainer zippedBac;
        block3: {
            zippedBac = new ByteArrayContainer();
            try {
                ZipOutputStream zos = new ZipOutputStream(zippedBac.getOutputStream());
                for (String iFilename : byteArrayContainerMap.keySet()) {
                    ByteArrayContainer sourceByteArrayContainer = byteArrayContainerMap.get(iFilename);
                    if (!StringUtils.isNotBlank((CharSequence)iFilename) || sourceByteArrayContainer == null || !sourceByteArrayContainer.isNotEmpty()) continue;
                    ZipEntry zipEntry = new ZipEntry(iFilename);
                    zos.putNextEntry(zipEntry);
                    StreamConnector.connect(sourceByteArrayContainer.getInputStream(), zos);
                }
                zos.close();
            }
            catch (Exception e) {
                if (exceptionHandler == null) break block3;
                exceptionHandler.handleException(e);
            }
        }
        return zippedBac;
    }

    private static String generateRandomDefaultFileName() {
        return DEFAULTZIPFILENAME + String.valueOf(System.currentTimeMillis()) + String.valueOf(Math.round(Math.random() * 1.0E9));
    }

    public Map<String, ByteArrayContainer> unzip() {
        Map<String, ByteArrayContainer> retmap = ByteArrayContainer.unzipIntoFilenameByteArrayContainerMap(this);
        if (retmap != null && retmap.size() > 0) {
            this.content = null;
            this.copyFrom(retmap.values().iterator().next());
        } else {
            this.content = null;
        }
        return retmap;
    }

    public static Map<String, ByteArrayContainer> unzipIntoFilenameByteArrayContainerMap(ByteArrayContainer byteArrayContainer) {
        ExceptionHandler exceptionHandler = null;
        return ByteArrayContainer.unzipIntoFilenameByteArrayContainerMap(byteArrayContainer, exceptionHandler);
    }

    public static Map<String, ByteArrayContainer> unzipIntoFilenameByteArrayContainerMap(ByteArrayContainer byteArrayContainer, ExceptionHandler exceptionHandler) {
        LinkedHashMap<String, ByteArrayContainer> retmap;
        block3: {
            retmap = new LinkedHashMap<String, ByteArrayContainer>();
            try {
                ZipInputStream zis = new ZipInputStream(byteArrayContainer.getInputStream());
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    ByteArrayContainer unzippedBac = new ByteArrayContainer();
                    StreamConnector.connect(zis, unzippedBac.getOutputStream());
                    retmap.put(zipEntry.getName(), unzippedBac);
                    zipEntry = zis.getNextEntry();
                }
            }
            catch (IOException e) {
                if (exceptionHandler == null) break block3;
                exceptionHandler.handleException(e);
            }
        }
        return retmap;
    }

    public static ByteArrayContainer createNewInstance() {
        ByteArrayContainer result = null;
        try {
            result = implementationForByteArrayContainerClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isContentInvalid() {
        return this.isContentInvalid;
    }

    public void setContentInvalid(boolean isContentInvalid) {
        this.isContentInvalid = isContentInvalid;
    }

    public PrintStream getPrintStreamWriter() {
        return this.getPrintStreamWriter("utf-8");
    }

    public PrintStream getPrintStreamWriter(String encoding) {
        boolean autoFlush = true;
        return this.getPrintStreamWriter(encoding, autoFlush);
    }

    public PrintStream getPrintStreamWriter(String encoding, boolean autoFlush) {
        PrintStream retval = null;
        OutputStream outputStream = this.getOutputStream();
        try {
            retval = new PrintStream(outputStream, autoFlush, encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException(e);
        }
        return retval;
    }

    public ByteArrayContainer setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public static ByteArrayContainer valueOf(ByteArrayContainer byteArrayContainer) {
        ByteArrayContainer retval = new ByteArrayContainer();
        if (byteArrayContainer != null) {
            retval.setContent(byteArrayContainer.getContent());
        }
        return retval;
    }

    static /* synthetic */ byte[] access$102(ByteArrayContainer x0, byte[] x1) {
        x0.content = x1;
        return x1;
    }
}

