/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.element;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;

public class ExceptionHandledResult<E> {
    protected E result = null;
    protected List<Exception> exceptionList = new ArrayList<Exception>();

    public ExceptionHandledResult(E result, Collection<Exception> exceptionCollection) {
        this.result = result;
        this.exceptionList.addAll(exceptionCollection);
    }

    public E getResult() {
        return this.result;
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public List<Exception> getExceptionList() {
        return ListUtils.unmodifiableList(this.exceptionList);
    }

    public boolean hasNoExceptions() {
        return this.exceptionList == null || this.exceptionList.isEmpty();
    }

    public boolean hasExceptions() {
        return !this.hasNoExceptions();
    }

    public boolean containsAssignableException(Class<? extends Exception> exceptionType) {
        return this.resolveAssignableException(exceptionType) != null;
    }

    public Exception resolveAssignableException(Class<? extends Exception> exceptionType) {
        Throwable retval = null;
        if (exceptionType != null && this.hasExceptions()) {
            Iterator<Exception> i$ = this.exceptionList.iterator();
            block0: while (i$.hasNext()) {
                Exception exception;
                for (Throwable cause = exception = i$.next(); cause != null; cause = cause.getCause()) {
                    if (!exceptionType.isAssignableFrom(cause.getClass()) || !(cause instanceof Exception)) continue;
                    retval = cause;
                    break block0;
                }
            }
        }
        return retval;
    }

    public void rethrowFirstExceptionIfAnyExceptionHasOccurred() throws Exception {
        if (this.hasExceptions()) {
            throw this.exceptionList.get(0);
        }
    }

    public void rethrowFirstExceptionAssignableToTypeIfAnyExceptionHasOccurred(Class<? extends Exception> exceptionType) throws Exception {
        Exception exception;
        if (this.hasExceptions() && (exception = this.resolveAssignableException(exceptionType)) != null) {
            throw exception;
        }
    }

    public Exception getFirstException() {
        Exception retval = null;
        if (this.hasExceptions()) {
            retval = this.exceptionList.get(0);
        }
        return retval;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExceptionHandledResult [result=");
        builder.append(this.result);
        builder.append(", exceptionList=");
        builder.append(this.exceptionList);
        builder.append("]");
        return builder.toString();
    }
}

