/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.element;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class FutureSimple<V>
implements Future<V> {
    private final AtomicBoolean shouldCancel = new AtomicBoolean(false);
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private V value = null;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.shouldCancel.set(true);
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    @Override
    public boolean isDone() {
        return this.countDownLatch.getCount() == 0L;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        V retval = null;
        this.countDownLatch.await();
        retval = this.value;
        return retval;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        V retval = null;
        this.countDownLatch.await(timeout, unit);
        retval = this.value;
        return retval;
    }

    public void setValue(V value) {
        this.value = value;
        this.countDownLatch.countDown();
    }

    public boolean getShouldCancel() {
        return this.shouldCancel.get();
    }

    public void setIsCancelled(boolean isCancelled) {
        this.isCancelled.set(isCancelled);
    }
}

