/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.element;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.array.ArrayUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterRegistration;
import org.omnaest.utils.structure.element.factory.Factory;
import org.omnaest.utils.structure.hierarchy.tree.object.ObjectToTreeNodeAdapter;
import org.omnaest.utils.structure.hierarchy.tree.object.ObjectTreeNavigator;
import org.omnaest.utils.structure.hierarchy.tree.object.ObjectTreeNode;

public class ObjectUtils {
    public static <C> C castArrayToMap(Class<? extends C> mapType, Class<?> keyType, Class<?> valueType, Object array) {
        LinkedHashMap<Object, Object> retval = null;
        if (mapType != null && keyType != null && valueType != null) {
            try {
                if (array instanceof Object[]) {
                    Object[] objects = (Object[])array;
                    if (LinkedHashMap.class.equals(mapType) || mapType.isInterface()) {
                        LinkedHashMap map = new LinkedHashMap();
                        boolean toggleIsKey = true;
                        Object lastKey = null;
                        for (Object iObject : objects) {
                            if (toggleIsKey) {
                                lastKey = iObject;
                            } else {
                                Object key = ObjectUtils.castTo(keyType, lastKey);
                                Object value = ObjectUtils.castTo(valueType, iObject);
                                map.put(key, value);
                            }
                            toggleIsKey = !toggleIsKey;
                        }
                        if (!toggleIsKey) {
                            Object key = ObjectUtils.castTo(keyType, lastKey);
                            Object value = null;
                            map.put(key, value);
                        }
                        retval = map;
                    } else if (ReflectionUtils.hasConstructorFor(mapType, Map.class)) {
                        Map map = ObjectUtils.castArrayToMap(LinkedHashMap.class, keyType, valueType, array);
                        retval = ReflectionUtils.newInstanceOf(mapType, map);
                    }
                } else if (array != null && array.getClass().isArray()) {
                    Object[] objects = ArrayUtils.toObject(array);
                    retval = ObjectUtils.castArrayToMap(mapType, keyType, valueType, objects);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (retval == null) {
            try {
                retval = array;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return (C)retval;
    }

    public static <C> C castArrayTo(Class<C> wrapperType, Class<?> elementType, Object array) {
        Object retval = null;
        if (wrapperType != null && elementType != null) {
            try {
                if (array instanceof Object[]) {
                    Object[] objects = (Object[])array;
                    if (ArrayList.class.equals(wrapperType) || List.class.isAssignableFrom(wrapperType) && wrapperType.isInterface()) {
                        ArrayList list = new ArrayList();
                        for (Object iObject : objects) {
                            list.add(ObjectUtils.castTo(elementType, iObject));
                        }
                        retval = list;
                    } else if (HashSet.class.equals(wrapperType) || Set.class.isAssignableFrom(wrapperType) && wrapperType.isInterface()) {
                        HashSet set = new HashSet();
                        for (Object iObject : objects) {
                            set.add(ObjectUtils.castTo(elementType, iObject));
                        }
                        retval = set;
                    } else if (Map.class.isAssignableFrom(wrapperType)) {
                        Class<C> mapType = wrapperType;
                        Class<?> keyType = elementType;
                        Class<?> valueType = elementType;
                        retval = ObjectUtils.castArrayToMap(mapType, keyType, valueType, array);
                    } else {
                        PrimitiveTypeArrayAnalysisResult primitiveTypeArrayAnalysisResult;
                        boolean isWrapperTypeAnArray = wrapperType.isArray();
                        if (isWrapperTypeAnArray && (primitiveTypeArrayAnalysisResult = ObjectUtils.analyzeForPrimitiveTypeArray(wrapperType)).isPrimitiveArray()) {
                            Object[] newObjects = ObjectUtils.castArrayTo(Object[].class, elementType, objects);
                            if (primitiveTypeArrayAnalysisResult.isBooleanArray()) {
                                boolean[] newArray = org.apache.commons.lang3.ArrayUtils.toPrimitive((Boolean[])((Boolean[])newObjects));
                                retval = newArray;
                            } else if (primitiveTypeArrayAnalysisResult.isByteArray()) {
                                byte[] newArray = org.apache.commons.lang3.ArrayUtils.toPrimitive((Byte[])((Byte[])newObjects));
                                retval = newArray;
                            } else if (primitiveTypeArrayAnalysisResult.isCharArray()) {
                                char[] newArray = org.apache.commons.lang3.ArrayUtils.toPrimitive((Character[])((Character[])newObjects));
                                retval = newArray;
                            } else if (primitiveTypeArrayAnalysisResult.isDoubleArray()) {
                                double[] newArray = org.apache.commons.lang3.ArrayUtils.toPrimitive((Double[])((Double[])newObjects));
                                retval = newArray;
                            } else if (primitiveTypeArrayAnalysisResult.isFloatArray()) {
                                float[] newArray = org.apache.commons.lang3.ArrayUtils.toPrimitive((Float[])((Float[])newObjects));
                                retval = newArray;
                            } else if (primitiveTypeArrayAnalysisResult.isIntArray()) {
                                int[] newArray = org.apache.commons.lang3.ArrayUtils.toPrimitive((Integer[])((Integer[])newObjects));
                                retval = newArray;
                            } else if (primitiveTypeArrayAnalysisResult.isLongArray()) {
                                long[] newArray = org.apache.commons.lang3.ArrayUtils.toPrimitive((Long[])((Long[])newObjects));
                                retval = newArray;
                            } else if (primitiveTypeArrayAnalysisResult.isShortArray()) {
                                short[] newArray = org.apache.commons.lang3.ArrayUtils.toPrimitive((Short[])((Short[])newObjects));
                                retval = newArray;
                            }
                        } else if (isWrapperTypeAnArray) {
                            Object[] newObjects = ArrayUtils.toObject(Array.newInstance(elementType, objects.length));
                            for (int ii = 0; ii < newObjects.length; ++ii) {
                                newObjects[ii] = ObjectUtils.castTo(elementType, objects[ii]);
                            }
                            retval = newObjects;
                        } else if (ReflectionUtils.hasConstructorFor(wrapperType, array)) {
                            retval = ReflectionUtils.newInstanceOf(wrapperType, array);
                        } else if (ReflectionUtils.hasConstructorFor(wrapperType, Collection.class)) {
                            Collection collection = ObjectUtils.castArrayTo(ArrayList.class, elementType, array);
                            retval = ReflectionUtils.newInstanceOf(wrapperType, collection);
                        }
                    }
                } else if (array != null && array.getClass().isArray()) {
                    Object[] objects = ArrayUtils.toObject(array);
                    retval = ObjectUtils.castArrayTo(wrapperType, elementType, objects);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (retval == null) {
            try {
                retval = array;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return (C)retval;
    }

    private static PrimitiveTypeArrayAnalysisResult analyzeForPrimitiveTypeArray(Class<?> type) {
        boolean isByteArray = byte[].class.equals(type);
        boolean isShortArray = !isByteArray && short[].class.equals(type);
        boolean isIntArray = !isShortArray && !isByteArray && int[].class.equals(type);
        boolean isLongArray = !isIntArray && !isShortArray && !isByteArray && long[].class.equals(type);
        boolean isFloatArray = !isLongArray && !isIntArray && !isShortArray && !isByteArray && float[].class.equals(type);
        boolean isDoubleArray = !isFloatArray && !isLongArray && !isIntArray && !isShortArray && !isByteArray && double[].class.equals(type);
        boolean isBooleanArray = !isDoubleArray && !isFloatArray && !isLongArray && !isIntArray && !isShortArray && !isByteArray && boolean[].class.equals(type);
        boolean isCharArray = !isBooleanArray && !isDoubleArray && !isFloatArray && !isLongArray && !isIntArray && !isShortArray && !isByteArray && char[].class.equals(type);
        boolean isPrimitiveArray = isByteArray || isShortArray || isIntArray || isLongArray || isFloatArray || isDoubleArray || isBooleanArray || isCharArray;
        return new PrimitiveTypeArrayAnalysisResult(isByteArray, isShortArray, isIntArray, isLongArray, isFloatArray, isDoubleArray, isBooleanArray, isCharArray, isPrimitiveArray);
    }

    public static <C> C castTo(Class<C> type, Object object) {
        Object retval;
        block32: {
            retval = null;
            if (object != null) {
                try {
                    Class<?> objectType = object.getClass();
                    boolean isObjectTypeString = String.class.equals(objectType);
                    if (String.class.equals(type)) {
                        retval = String.valueOf(object);
                        break block32;
                    }
                    if (Integer.class.equals(type) && isObjectTypeString) {
                        retval = Integer.valueOf((String)object);
                        break block32;
                    }
                    if (Integer.TYPE.equals(type) && isObjectTypeString) {
                        retval = Integer.valueOf((String)object);
                        break block32;
                    }
                    if (Long.class.equals(type) && isObjectTypeString) {
                        retval = Long.valueOf((String)object);
                        break block32;
                    }
                    if (Long.TYPE.equals(type) && isObjectTypeString) {
                        retval = Long.valueOf((String)object);
                        break block32;
                    }
                    if (Byte.class.equals(type) && isObjectTypeString) {
                        retval = Byte.valueOf((String)object);
                        break block32;
                    }
                    if (Byte.TYPE.equals(type) && isObjectTypeString) {
                        retval = Byte.valueOf((String)object);
                        break block32;
                    }
                    if (Short.class.equals(type) && isObjectTypeString) {
                        retval = Short.valueOf((String)object);
                        break block32;
                    }
                    if (Short.TYPE.equals(type) && isObjectTypeString) {
                        retval = Short.valueOf((String)object);
                        break block32;
                    }
                    if (Float.class.equals(type) && isObjectTypeString) {
                        retval = Float.valueOf((String)object);
                        break block32;
                    }
                    if (Float.TYPE.equals(type) && isObjectTypeString) {
                        retval = Float.valueOf((String)object);
                        break block32;
                    }
                    if (Double.class.equals(type) && isObjectTypeString) {
                        retval = Double.valueOf((String)object);
                        break block32;
                    }
                    if (Double.TYPE.equals(type) && isObjectTypeString) {
                        retval = Double.valueOf((String)object);
                        break block32;
                    }
                    if (BigDecimal.class.equals(type) && isObjectTypeString) {
                        retval = new BigDecimal((String)object);
                        break block32;
                    }
                    if (BigInteger.class.equals(type) && isObjectTypeString) {
                        retval = new BigInteger((String)object);
                        break block32;
                    }
                    if (Boolean.class.equals(type) && isObjectTypeString) {
                        retval = Boolean.valueOf((String)object);
                        break block32;
                    }
                    if (Boolean.TYPE.equals(type) && isObjectTypeString) {
                        retval = Boolean.valueOf((String)object);
                        break block32;
                    }
                    if ((Double.TYPE.equals(type) || Double.class.equals(type)) && (Float.TYPE.equals(objectType) || Float.class.equals(objectType))) {
                        retval = (double)((Float)object).floatValue();
                        break block32;
                    }
                    if ((Long.TYPE.equals(type) || Long.class.equals(type)) && (Integer.TYPE.equals(objectType) || Integer.class.equals(objectType))) {
                        retval = (long)((Integer)object).intValue();
                        break block32;
                    }
                    if ((Long.TYPE.equals(type) || Long.class.equals(type)) && (Short.TYPE.equals(objectType) || Short.class.equals(objectType))) {
                        retval = (long)((Short)object).shortValue();
                        break block32;
                    }
                    if ((Long.TYPE.equals(type) || Long.class.equals(type)) && (Byte.TYPE.equals(objectType) || Byte.class.equals(objectType))) {
                        retval = (long)((Byte)object).byteValue();
                        break block32;
                    }
                    if ((Integer.TYPE.equals(type) || Integer.class.equals(type)) && (Short.TYPE.equals(objectType) || Short.class.equals(objectType))) {
                        retval = (int)((Short)object).shortValue();
                        break block32;
                    }
                    if ((Integer.TYPE.equals(type) || Integer.class.equals(type)) && (Byte.TYPE.equals(objectType) || Byte.class.equals(objectType))) {
                        retval = (int)((Byte)object).byteValue();
                        break block32;
                    }
                    ElementConverter<?, C> elementConverter = ElementConverterRegistration.determineElementConverterFor(objectType, type);
                    if (elementConverter != null) {
                        retval = elementConverter.convert(object);
                        break block32;
                    }
                    C createdInstance = ReflectionUtils.newInstanceOf(type, object);
                    if (createdInstance != null) {
                        retval = createdInstance;
                        break block32;
                    }
                    createdInstance = ReflectionUtils.newInstanceByValueOf(type, object);
                    if (createdInstance != null) {
                        retval = createdInstance;
                        break block32;
                    }
                    try {
                        retval = type.cast(object);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (retval == null) {
                        retval = object;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (C)retval;
    }

    public static boolean isPrimitiveWrapperType(Class<?> type) {
        return type != null && (Integer.class.equals(type) || Long.class.equals(type) || Short.class.equals(type) || Byte.class.equals(type) || Character.class.equals(type) || Float.class.equals(type) || Double.class.equals(type) || Boolean.class.equals(type) || Void.class.equals(type));
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return type != null && type.isPrimitive();
    }

    public static boolean isPrimitiveOrPrimitiveWrapperType(Class<?> type) {
        return ObjectUtils.isPrimitiveType(type) || ObjectUtils.isPrimitiveWrapperType(type);
    }

    public static boolean isString(Object object) {
        return ObjectUtils.isAssignableFromInstance(String.class, object);
    }

    public static boolean isMap(Object object) {
        return ObjectUtils.isAssignableFromInstance(Map.class, object);
    }

    public static boolean isSortedMap(Object object) {
        return ObjectUtils.isAssignableFromInstance(SortedMap.class, object);
    }

    public static boolean isSortedSet(Object object) {
        return ObjectUtils.isAssignableFromInstance(SortedSet.class, object);
    }

    public static boolean isList(Object object) {
        return ObjectUtils.isAssignableFromInstance(List.class, object);
    }

    public static boolean isCollection(Object object) {
        return ObjectUtils.isAssignableFromInstance(Collection.class, object);
    }

    public static boolean isIterable(Object object) {
        return ObjectUtils.isAssignableFromInstance(Iterable.class, object);
    }

    public static boolean isAssignableFromInstance(Class<?> targetType, Object object) {
        return object != null && targetType != null && targetType.isAssignableFrom(object.getClass());
    }

    public static boolean isAnyTypeAssignableFromType(Iterable<Class<?>> targetTypes, Class<?> sourceType) {
        boolean retval;
        block1: {
            retval = false;
            if (targetTypes == null || sourceType == null) break block1;
            for (Class<?> targetType : targetTypes) {
                if (targetType != null && (retval = targetType.isAssignableFrom(sourceType))) break;
            }
        }
        return retval;
    }

    public static boolean isAnyTypeAssignableFromInstance(Iterable<Class<?>> targetTypes, Object object) {
        boolean retval;
        block1: {
            Class<?> targetType;
            retval = false;
            if (targetTypes == null) break block1;
            Iterator<Class<?>> i$ = targetTypes.iterator();
            while (i$.hasNext() && !(retval = ObjectUtils.isAssignableFromInstance(targetType = i$.next(), object))) {
            }
        }
        return retval;
    }

    public static boolean isArray(Object object) {
        return ArrayUtils.isArray(object);
    }

    public static Class<?> objectTypeFor(Class<?> type) {
        return type != null ? (ObjectUtils.isPrimitiveType(type) ? ObjectUtils.primitiveWrapperTypeFor(type) : type) : null;
    }

    public static Class<?> primitiveWrapperTypeFor(Class<?> primitiveType) {
        Class retval = null;
        if (primitiveType != null) {
            if (primitiveType.isPrimitive()) {
                if (primitiveType.equals(Integer.TYPE)) {
                    retval = Integer.class;
                } else if (primitiveType.equals(Long.TYPE)) {
                    retval = Long.class;
                } else if (primitiveType.equals(Short.TYPE)) {
                    retval = Short.class;
                } else if (primitiveType.equals(Byte.TYPE)) {
                    retval = Byte.class;
                } else if (primitiveType.equals(Character.TYPE)) {
                    retval = Character.class;
                } else if (primitiveType.equals(Float.TYPE)) {
                    retval = Float.class;
                } else if (primitiveType.equals(Double.TYPE)) {
                    retval = Double.class;
                } else if (primitiveType.equals(Boolean.TYPE)) {
                    retval = Boolean.class;
                } else if (primitiveType.equals(Void.TYPE)) {
                    retval = Void.class;
                }
            } else if (ObjectUtils.isPrimitiveWrapperType(primitiveType)) {
                return primitiveType;
            }
        }
        return retval;
    }

    public static <O> O defaultIfNull(O object, O defaultObject) {
        O[] defaultObjects = null;
        return ObjectUtils.defaultIfNull(object, defaultObject, defaultObjects);
    }

    public static <O> O defaultIfNull(O object, O defaultObject, O ... defaultObjects) {
        Object retval = null;
        if (object != null) {
            retval = object;
        } else if (defaultObject != null) {
            retval = defaultObject;
        } else if (defaultObjects != null && defaultObjects.length > 1) {
            retval = ObjectUtils.defaultIfNull(defaultObjects[0], defaultObjects[1], org.apache.commons.lang3.ArrayUtils.subarray((Object[])defaultObjects, (int)2, (int)defaultObjects.length));
        } else if (defaultObjects != null && defaultObjects.length == 1) {
            retval = defaultObjects[0];
        }
        return (O)retval;
    }

    public static <O> O defaultIfNull(O object, Factory<O> defaultObjectFactory) {
        return (O)(object != null ? object : (defaultObjectFactory != null ? defaultObjectFactory.newInstance() : null));
    }

    public static String toStringAsNestedHierarchy(Object object) {
        return String.valueOf(ObjectUtils.treeNavigator(object));
    }

    public static String toStringAsSimpleNestedHierarchy(Object object) {
        String regex = "ObjectModel \\[object=[^,]*, setterMethod=[^,]*, getterMethod=[^ ]* ?([^ ]*) ?[^,]*, field=[^,]*, propertyName=([^\\]]*)\\]";
        String nestedHierarchy = ObjectUtils.toStringAsNestedHierarchy(object);
        nestedHierarchy = nestedHierarchy.replaceAll(regex, "$1 $2");
        return nestedHierarchy;
    }

    public static ObjectTreeNavigator treeNavigator(Object object) {
        return new ObjectTreeNavigator(new ObjectToTreeNodeAdapter(new ObjectTreeNode.ObjectModel(object)));
    }

    public static Class<?> typeOf(Object instance) {
        Class<?> retval = null;
        if (instance != null) {
            retval = instance.getClass();
        }
        return retval;
    }

    protected static class PrimitiveTypeArrayAnalysisResult {
        protected final boolean isByteArray;
        protected final boolean isShortArray;
        protected final boolean isIntArray;
        protected final boolean isLongArray;
        protected final boolean isFloatArray;
        protected final boolean isDoubleArray;
        protected final boolean isBooleanArray;
        protected final boolean isCharArray;
        protected final boolean isPrimitiveArray;

        public PrimitiveTypeArrayAnalysisResult(boolean isByteArray, boolean isShortArray, boolean isIntArray, boolean isLongArray, boolean isFloatArray, boolean isDoubleArray, boolean isBooleanArray, boolean isCharArray, boolean isPrimitiveArray) {
            this.isByteArray = isByteArray;
            this.isShortArray = isShortArray;
            this.isIntArray = isIntArray;
            this.isLongArray = isLongArray;
            this.isFloatArray = isFloatArray;
            this.isDoubleArray = isDoubleArray;
            this.isBooleanArray = isBooleanArray;
            this.isCharArray = isCharArray;
            this.isPrimitiveArray = isPrimitiveArray;
        }

        public boolean isByteArray() {
            return this.isByteArray;
        }

        public boolean isShortArray() {
            return this.isShortArray;
        }

        public boolean isIntArray() {
            return this.isIntArray;
        }

        public boolean isLongArray() {
            return this.isLongArray;
        }

        public boolean isFloatArray() {
            return this.isFloatArray;
        }

        public boolean isDoubleArray() {
            return this.isDoubleArray;
        }

        public boolean isBooleanArray() {
            return this.isBooleanArray;
        }

        public boolean isCharArray() {
            return this.isCharArray;
        }

        public boolean isPrimitiveArray() {
            return this.isPrimitiveArray;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PrimitiveTypeArrayAnalysisResult [isByteArray=");
            builder.append(this.isByteArray);
            builder.append(", isShortArray=");
            builder.append(this.isShortArray);
            builder.append(", isIntArray=");
            builder.append(this.isIntArray);
            builder.append(", isLongArray=");
            builder.append(this.isLongArray);
            builder.append(", isFloatArray=");
            builder.append(this.isFloatArray);
            builder.append(", isDoubleArray=");
            builder.append(this.isDoubleArray);
            builder.append(", isBooleanArray=");
            builder.append(this.isBooleanArray);
            builder.append(", isCharArray=");
            builder.append(this.isCharArray);
            builder.append(", isPrimitiveArray=");
            builder.append(this.isPrimitiveArray);
            builder.append("]");
            return builder.toString();
        }
    }
}

