/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.element.accessor;

import org.omnaest.utils.structure.element.ElementHolder;
import org.omnaest.utils.structure.element.accessor.Accessor;
import org.omnaest.utils.structure.element.accessor.AccessorReadable;
import org.omnaest.utils.structure.element.accessor.AccessorWritable;

public class AccessorDecorator<E>
implements Accessor<E> {
    protected Accessor<E> accessor = null;

    public AccessorDecorator(Accessor<E> accessor) {
        this.setAccessor(accessor);
    }

    public AccessorDecorator(AccessorReadable<E> accessorReadable) {
        this.setAccessor(accessorReadable);
    }

    public AccessorDecorator(AccessorWritable<E> accessorWritable) {
        this.setAccessor(accessorWritable);
    }

    public AccessorDecorator(E element) {
        this.accessor = new ElementHolder<E>(element);
    }

    @Override
    public E getElement() {
        return this.accessor != null ? (E)this.accessor.getElement() : null;
    }

    @Override
    public Accessor<E> setElement(E element) {
        if (this.accessor != null) {
            this.accessor.setElement(element);
        }
        return this;
    }

    public void setAccessor(Accessor<E> accessor) {
        this.accessor = accessor;
    }

    public void setAccessor(final AccessorReadable<E> accessorReadable) {
        this.accessor = accessorReadable == null ? null : new Accessor<E>(){

            @Override
            public E getElement() {
                return accessorReadable.getElement();
            }

            @Override
            public Accessor<E> setElement(E element) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setAccessor(final AccessorWritable<E> accessorWritable) {
        this.accessor = accessorWritable == null ? null : new Accessor<E>(){

            @Override
            public E getElement() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Accessor<E> setElement(E element) {
                accessorWritable.setElement(element);
                return this;
            }
        };
    }

    public Accessor<E> getAccessor() {
        return this.accessor;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AccessorDecorator [accessor=");
        builder.append(this.accessor);
        builder.append("]");
        return builder.toString();
    }
}

