/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.element.cached;

public class CachedElement<T> {
    protected CachedValue<T> cachedValue = this.newCachedValue();
    protected ValueResolver<T> valueResolver = null;

    public CachedElement(ValueResolver<T> valueResolver) {
        this.valueResolver = valueResolver;
    }

    public CachedElement(T value) {
        this.valueResolver = new ValueResolverSimple<T>(value);
    }

    public T getValue() {
        T value = this.cachedValue.getValue();
        if (value == null && this.valueResolver != null) {
            value = this.valueResolver.resolveValue();
            this.cachedValue.setValue(value);
        }
        return value;
    }

    public T getValueFromCacheOnly() {
        return this.cachedValue.getValue();
    }

    public boolean hasValueResolved() {
        return this.getValueFromCacheOnly() != null;
    }

    public void setValueResolver(ValueResolver<T> valueResolver) {
        this.valueResolver = valueResolver;
    }

    public ValueResolver<T> getValueResolver() {
        return this.valueResolver;
    }

    public CachedElement<T> clearCache() {
        this.cachedValue.setValue(null);
        return this;
    }

    protected CachedValue<T> newCachedValue() {
        return new CachedValue<T>(){
            private T value = null;

            @Override
            public void setValue(T value) {
                this.value = value;
            }

            @Override
            public T getValue() {
                return this.value;
            }
        };
    }

    protected static interface CachedValue<T> {
        public T getValue();

        public void setValue(T var1);
    }

    public static class ValueResolverSimple<T>
    implements ValueResolver<T> {
        protected T value = null;

        public ValueResolverSimple(T value) {
            this.value = value;
        }

        @Override
        public T resolveValue() {
            return this.value;
        }
    }

    public static interface ValueResolver<T> {
        public T resolveValue();
    }
}

