/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.element.cached;

import org.omnaest.utils.structure.element.cached.CachedElement;
import org.omnaest.utils.time.DurationCapture;

public class CachedElementTimed<T>
extends CachedElement<T> {
    protected Long validCacheDurationInMilliseconds = null;

    public CachedElementTimed(CachedElement.ValueResolver<T> valueResolver, Long validCacheDurationInMilliseconds) {
        super(valueResolver);
        this.validCacheDurationInMilliseconds = validCacheDurationInMilliseconds;
    }

    @Override
    protected CachedElement.CachedValue<T> newCachedValue() {
        final CachedElement.CachedValue cachedValue = super.newCachedValue();
        return new CachedElement.CachedValue<T>(){
            protected DurationCapture durationCapture = DurationCapture.newInstance().startTimeMeasurement();

            @Override
            public T getValue() {
                Object retval = null;
                if (this.durationCapture.getInterimTimeInMilliseconds() <= CachedElementTimed.this.validCacheDurationInMilliseconds) {
                    retval = cachedValue.getValue();
                } else {
                    cachedValue.setValue(null);
                }
                return retval;
            }

            @Override
            public void setValue(T value) {
                cachedValue.setValue(value);
                this.durationCapture.resetTimer();
            }
        };
    }

    public Long getValidCacheDurationInMilliseconds() {
        return this.validCacheDurationInMilliseconds;
    }

    public void setValidCacheDurationInMilliseconds(Long validCacheDurationInMilliseconds) {
        this.validCacheDurationInMilliseconds = validCacheDurationInMilliseconds;
    }
}

