/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.element.converter;

import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverter;
import org.omnaest.utils.structure.element.converter.ElementBidirectionalConverterSerializable;
import org.omnaest.utils.structure.element.converter.ElementConverter;

public class ElementConverterHelper {
    public static <TO, FROM> TO convert(FROM element, Class<? extends ElementConverter<?, ?>> ... elementConverterTypes) {
        Object retval = element;
        if (elementConverterTypes != null) {
            try {
                for (Class<? extends ElementConverter<?, ?>> elementConverterType : elementConverterTypes) {
                    ElementConverter<?, ?> elementConverter = ReflectionUtils.newInstanceOf(elementConverterType, new Object[0]);
                    retval = elementConverter.convert(retval);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (TO)retval;
    }

    public static <FROM, TO> ElementBidirectionalConverter<TO, FROM> inverse(final ElementBidirectionalConverter<FROM, TO> elementBidirectionalConverter) {
        Assert.isNotNull(elementBidirectionalConverter, "elementBidirectionalConverter must not be null");
        return new ElementBidirectionalConverterSerializable<TO, FROM>(){
            private static final long serialVersionUID = 6099568517954297832L;

            @Override
            public TO convertBackwards(FROM element) {
                return elementBidirectionalConverter.convert(element);
            }

            @Override
            public FROM convert(TO element) {
                return elementBidirectionalConverter.convertBackwards(element);
            }
        };
    }
}

