/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.element.converter;

import java.io.Serializable;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.collection.ComparatorUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.element.converter.ElementConverterBooleanToString;
import org.omnaest.utils.structure.element.converter.ElementConverterIdentitiyCast;
import org.omnaest.utils.structure.element.converter.ElementConverterNumberToString;
import org.omnaest.utils.structure.element.converter.ElementConverterObjectToString;
import org.omnaest.utils.structure.element.converter.ElementConverterStringToBigDecimal;
import org.omnaest.utils.structure.element.converter.ElementConverterStringToBigInteger;
import org.omnaest.utils.structure.element.converter.ElementConverterStringToByte;
import org.omnaest.utils.structure.element.converter.ElementConverterStringToDouble;
import org.omnaest.utils.structure.element.converter.ElementConverterStringToFloat;
import org.omnaest.utils.structure.element.converter.ElementConverterStringToInteger;
import org.omnaest.utils.structure.element.converter.ElementConverterStringToLong;
import org.omnaest.utils.structure.element.converter.ElementConverterStringToShort;
import org.omnaest.utils.structure.element.converter.ElementConverterTypeAware;

public class ElementConverterRegistration
implements Serializable {
    private static final long serialVersionUID = 4667088490394555133L;
    private static final Comparator<ElementConverterTypeAware.SourceAndTargetType<?, ?>> comparator = ComparatorUtils.comparatorDecoratorUsingWeakHashMapCache(new Comparator<ElementConverterTypeAware.SourceAndTargetType<?, ?>>(){

        @Override
        public int compare(ElementConverterTypeAware.SourceAndTargetType<?, ?> sourceAndTargetType, ElementConverterTypeAware.SourceAndTargetType<?, ?> sourceAndTargetType2) {
            Class<?> sourceType2;
            int retval = 0;
            Class<?> sourceType = sourceAndTargetType.getSourceType();
            retval = this.determineAssignmentBasedComparisonValueFor(sourceType, sourceType2 = sourceAndTargetType2.getSourceType());
            if (retval == 0) {
                Class<?> targetType = sourceAndTargetType.getTargetType();
                Class<?> targetType2 = sourceAndTargetType2.getTargetType();
                retval = this.determineAssignmentBasedComparisonValueFor(targetType, targetType2);
            }
            if (retval == 0) {
                retval = String.valueOf(sourceAndTargetType).compareTo(String.valueOf(sourceAndTargetType2));
            }
            return retval;
        }

        private int determineAssignmentBasedComparisonValueFor(Class<?> type1, Class<?> type2) {
            int retval = 0;
            if (!type1.equals(type2)) {
                if (type1.isAssignableFrom(type2)) {
                    retval = 1;
                } else if (type2.isAssignableFrom(type1)) {
                    retval = -1;
                }
            }
            return retval;
        }
    });
    public static final SortedMap<ElementConverterTypeAware.SourceAndTargetType<?, ?>, ElementConverter<?, ?>> sourceAndTargetTypeToElementConverterMap = new ConcurrentSkipListMap(comparator);

    public static <FROM, TO> ElementConverter<FROM, TO> determineElementConverterFor(Class<FROM> sourceType, Class<TO> targetType) {
        Class<?> targetTypeNormalized;
        ElementConverter elementConverter = null;
        Class<?> sourceTypeNormalized = ObjectUtils.objectTypeFor(sourceType);
        if (sourceTypeNormalized.isAssignableFrom(targetTypeNormalized = ObjectUtils.objectTypeFor(targetType))) {
            elementConverter = new ElementConverterIdentitiyCast();
        } else if (sourceType != null && targetType != null) {
            for (ElementConverterTypeAware.SourceAndTargetType<?, ?> sourceAndTargetType : sourceAndTargetTypeToElementConverterMap.keySet()) {
                Class<?> iSourceType = ObjectUtils.objectTypeFor(sourceAndTargetType.getSourceType());
                Class<?> iTargetType = ObjectUtils.objectTypeFor(sourceAndTargetType.getTargetType());
                boolean isAssignableFromSourceType = iSourceType.isAssignableFrom(sourceTypeNormalized);
                boolean isAssignableToTargetType = targetTypeNormalized.isAssignableFrom(iTargetType);
                if (!isAssignableFromSourceType || !isAssignableToTargetType) continue;
                elementConverter = (ElementConverter)sourceAndTargetTypeToElementConverterMap.get(sourceAndTargetType);
                break;
            }
        }
        return elementConverter;
    }

    public static void registerElementConverterTypeAware(Class<? extends ElementConverterTypeAware<?, ?>> elementConverterTypeAwareType) {
        ElementConverterRegistration.registerElementConverterTypeAware(ReflectionUtils.newInstanceOf(elementConverterTypeAwareType, new Object[0]));
    }

    public static void registerElementConverterTypeAware(ElementConverterTypeAware<?, ?> elementConverterTypeAware) {
        if (elementConverterTypeAware != null) {
            sourceAndTargetTypeToElementConverterMap.put(elementConverterTypeAware.getSourceAndTargetType(), elementConverterTypeAware);
        }
    }

    public static void registerElementConverter(Class<? extends ElementConverter<?, ?>> elementConverterType, Class<?> sourceType, Class<?> targetType) {
        ElementConverter<?, ?> elementConverter = ReflectionUtils.newInstanceOf(elementConverterType, new Object[0]);
        ElementConverterRegistration.registerElementConverter(elementConverter, sourceType, targetType);
    }

    public static void registerElementConverter(ElementConverter<?, ?> elementConverter, Class<?> sourceType, Class<?> targetType) {
        if (elementConverter != null && sourceType != null && targetType != null) {
            sourceAndTargetTypeToElementConverterMap.put(new ElementConverterTypeAware.SourceAndTargetType(sourceType, targetType), elementConverter);
        }
    }

    static {
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterNumberToString.class);
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterObjectToString.class);
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterBooleanToString.class);
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterStringToInteger.class);
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterStringToLong.class);
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterStringToByte.class);
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterStringToShort.class);
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterStringToBigDecimal.class);
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterStringToBigInteger.class);
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterStringToDouble.class);
        ElementConverterRegistration.registerElementConverterTypeAware(ElementConverterStringToFloat.class);
    }
}

