/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.element.converter;

import java.io.Serializable;
import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.structure.element.converter.ElementConverter;

public interface ElementConverterTypeAware<FROM, TO>
extends ElementConverter<FROM, TO> {
    public SourceAndTargetType<FROM, TO> getSourceAndTargetType();

    public static class SourceAndTargetType<FROM, TO>
    implements Serializable {
        private static final long serialVersionUID = 7691608527507412541L;
        private final Class<? extends FROM> sourceType;
        private final Class<? extends TO> targetType;

        public SourceAndTargetType(Class<? extends FROM> sourceType, Class<? extends TO> targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            Assert.isNotNull("source and target type must be not null", sourceType, targetType, new Object[0]);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SourceAndTargetType [sourceType=");
            builder.append(this.sourceType);
            builder.append(", targetType=");
            builder.append(this.targetType);
            builder.append("]");
            return builder.toString();
        }

        public Class<FROM> getSourceType() {
            return this.sourceType;
        }

        public Class<TO> getTargetType() {
            return this.targetType;
        }
    }
}

