/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.element.factory.concrete;

import org.omnaest.utils.assertion.Assert;
import org.omnaest.utils.reflection.ReflectionUtils;
import org.omnaest.utils.structure.element.factory.FactoryTypeAware;

public class FactoryTypeAwareReflectionBased<E>
implements FactoryTypeAware<E> {
    private final Class<? extends E> type;

    public FactoryTypeAwareReflectionBased(Class<? extends E> type) {
        this.type = type;
        Assert.isNotNull(type, "The given type must not be null");
    }

    @Override
    public E newInstance() {
        return ReflectionUtils.newInstanceOf(this.type, new Object[0]);
    }

    @Override
    public Class<?> getInstanceType() {
        return this.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FactoryTypeAwareReflectionBased [type=");
        builder.append(this.type);
        builder.append("]");
        return builder.toString();
    }
}

