/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.hierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;

public class TokenMonoHierarchy<E, V> {
    protected TokenElementNode tokenElementNodeRoot = new TokenElementNode(null, null);

    public TokenMonoHierarchy<E, V> addTokenElementPathWithValues(TokenElementPath<E> tokenElementPath, V ... values) {
        if (tokenElementPath != null && tokenElementPath.isValid() && values.length > 0) {
            List<E> tokenElementList = tokenElementPath.getTokenElementList();
            Navigator navigator = this.getNavigator();
            for (E tokenElement : tokenElementList) {
                navigator.navigateToChildAndCreateItIfNotExisting(tokenElement);
            }
            navigator.addValuesToCurrentNode(values);
        }
        return this;
    }

    public Navigator getNavigator() {
        return new Navigator(this.tokenElementNodeRoot);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MonoHierarchy [tokenElementNodeRoot=");
        builder.append(this.tokenElementNodeRoot);
        builder.append("]");
        return builder.toString();
    }

    public class Navigator {
        protected TokenElementNode tokenElementNode = null;
        protected boolean navigationSuccessful = false;

        protected Navigator(TokenElementNode tokenElementNode) {
            this.tokenElementNode = tokenElementNode;
        }

        public Navigator newNavigatorFork() {
            return new Navigator(this.tokenElementNode);
        }

        public E getTokenElement() {
            return this.tokenElementNode != null ? (Object)this.tokenElementNode.getTokenElement() : null;
        }

        public List<E> getTokenElementOfChildrenList() {
            ArrayList retlist = new ArrayList();
            if (this.hasChildren()) {
                Navigator navigator = this.newNavigatorFork();
                navigator.navigateToFirstChild();
                while (navigator.isNavigationSuccessful()) {
                    retlist.add(navigator.getTokenElement());
                    navigator.navigateToNextSibling();
                }
            }
            return retlist;
        }

        public List<E> determineTokenPathElementList() {
            ArrayList retlist = new ArrayList();
            for (TokenElementNode tokenElementNode = this.tokenElementNode; tokenElementNode != null && tokenElementNode.getTokenElement() != null; tokenElementNode = tokenElementNode.getParentTokenElementNode()) {
                retlist.add(0, tokenElementNode.getTokenElement());
            }
            return retlist;
        }

        public boolean hasValues() {
            return !this.getValues().isEmpty();
        }

        public Navigator navigateToNextNodeWithValues() {
            this.navigationSuccessful = false;
            Navigator navigator = this.newNavigatorFork();
            boolean navigationSuccessful = true;
            boolean hasValues = false;
            while (navigationSuccessful && !hasValues) {
                if (navigator.hasChildren()) {
                    navigator.navigateToFirstChild();
                    hasValues = navigator.hasValues();
                } else if (navigator.hasNextSibling()) {
                    navigator.navigateToNextSibling();
                    hasValues = navigator.hasValues();
                } else if (navigator.hasParent()) {
                    navigator.navigateToParent();
                    hasValues = false;
                }
                navigationSuccessful = navigator.isNavigationSuccessful();
            }
            if (hasValues && navigationSuccessful) {
                this.tokenElementNode = navigator.tokenElementNode;
                this.navigationSuccessful = true;
            }
            return this;
        }

        public Navigator navigateToNextSibling() {
            return this.navigateToSibling(1);
        }

        public Navigator navigateToPreviousSibling() {
            return this.navigateToSibling(1);
        }

        public Navigator navigateToSibling(int relativeIndexPosition) {
            this.navigationSuccessful = false;
            TokenElementNode tokenElementNodeSibling = this.determineSiblingTokenElementNode(relativeIndexPosition);
            if (tokenElementNodeSibling != null) {
                this.tokenElementNode = tokenElementNodeSibling;
                this.navigationSuccessful = true;
            }
            return this;
        }

        public boolean hasNextSibling() {
            return this.determineSiblingTokenElementNode(1) != null;
        }

        public boolean hasPreviousSibling() {
            return this.determineSiblingTokenElementNode(-1) != null;
        }

        public boolean hasSibling(int relativeIndexPosition) {
            return this.determineSiblingTokenElementNode(relativeIndexPosition) != null;
        }

        protected TokenElementNode determineSiblingTokenElementNode(int relativeIndexPosition) {
            int newIndex;
            Map tokenElementTotokenElementNodeChildrenMap;
            List<TokenElementNode> siblingList;
            int index;
            TokenElementNode parentTokenElementNode;
            TokenElementNode retval = null;
            TokenElementNode tokenElementNode = this.tokenElementNode;
            if (tokenElementNode != null && (parentTokenElementNode = tokenElementNode.getParentTokenElementNode()) != null && (index = (siblingList = org.omnaest.utils.structure.collection.list.ListUtils.valueOf((tokenElementTotokenElementNodeChildrenMap = parentTokenElementNode.getTokenElementTotokenElementNodeChildrenMap()).values())).indexOf(tokenElementNode)) >= 0 && (newIndex = index + relativeIndexPosition) >= 0 && newIndex < siblingList.size()) {
                retval = siblingList.get(newIndex);
            }
            return retval;
        }

        public boolean hasChildren() {
            return !this.tokenElementNode.getTokenElementTotokenElementNodeChildrenMap().isEmpty();
        }

        public boolean hasParent() {
            return this.tokenElementNode.getParentTokenElementNode() != null;
        }

        protected Navigator navigateToChildAndCreateItIfNotExisting(E tokenElement) {
            Map tokenElementTotokenElementNodeChildrenMap = this.tokenElementNode.getTokenElementTotokenElementNodeChildrenMap();
            if (!tokenElementTotokenElementNodeChildrenMap.containsKey(tokenElement)) {
                TokenElementNode parentTokenElementNode = this.tokenElementNode;
                tokenElementTotokenElementNodeChildrenMap.put(tokenElement, new TokenElementNode(parentTokenElementNode, tokenElement));
            }
            this.navigateToChild(tokenElement);
            return this;
        }

        public Navigator navigateToChild(E tokenElement) {
            this.navigationSuccessful = false;
            Map tokenElementTotokenElementNodeChildrenMap = this.tokenElementNode.getTokenElementTotokenElementNodeChildrenMap();
            if (tokenElementTotokenElementNodeChildrenMap.containsKey(tokenElement)) {
                this.tokenElementNode = tokenElementTotokenElementNodeChildrenMap.get(tokenElement);
                this.navigationSuccessful = true;
            }
            return this;
        }

        public Navigator navigateToFirstChild() {
            this.navigationSuccessful = false;
            Map tokenElementTotokenElementNodeChildrenMap = this.tokenElementNode.getTokenElementTotokenElementNodeChildrenMap();
            if (!tokenElementTotokenElementNodeChildrenMap.isEmpty()) {
                Object firstKey = tokenElementTotokenElementNodeChildrenMap.keySet().iterator().next();
                this.tokenElementNode = tokenElementTotokenElementNodeChildrenMap.get(firstKey);
                this.navigationSuccessful = true;
            }
            return this;
        }

        protected Navigator addValuesToCurrentNode(V ... values) {
            List valueList = this.tokenElementNode.getValueList();
            valueList.addAll(Arrays.asList(values));
            return this;
        }

        public List<V> getValues() {
            return ListUtils.unmodifiableList(this.tokenElementNode.getValueList());
        }

        public Navigator navigateToParent() {
            TokenElementNode parentTokenElementNode = this.tokenElementNode.getParentTokenElementNode();
            if (parentTokenElementNode != null) {
                this.tokenElementNode = parentTokenElementNode;
                this.navigationSuccessful = true;
            } else {
                this.navigationSuccessful = false;
            }
            return this;
        }

        public boolean isNavigationSuccessful() {
            return this.navigationSuccessful;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Navigator [tokenElementNode=");
            builder.append(this.tokenElementNode);
            builder.append(", navigationSuccessful=");
            builder.append(this.navigationSuccessful);
            builder.append("]");
            return builder.toString();
        }
    }

    protected class TokenElementNode {
        private Map<E, TokenElementNode> tokenElementTotokenElementNodeChildrenMap = new LinkedHashMap();
        private List<V> valueList = new ArrayList();
        private TokenElementNode parentTokenElementNode = null;
        private E tokenElement = null;

        public TokenElementNode(TokenElementNode parentTokenElementNode, E tokenElement) {
            this.parentTokenElementNode = parentTokenElementNode;
            this.tokenElement = tokenElement;
        }

        public List<V> getValueList() {
            return this.valueList;
        }

        public TokenElementNode getParentTokenElementNode() {
            return this.parentTokenElementNode;
        }

        public void setParentTokenElementNode(TokenElementNode parentTokenElementNode) {
            this.parentTokenElementNode = parentTokenElementNode;
        }

        public E getTokenElement() {
            return this.tokenElement;
        }

        public void setTokenElement(E tokenElement) {
            this.tokenElement = tokenElement;
        }

        public Map<E, TokenElementNode> getTokenElementTotokenElementNodeChildrenMap() {
            return this.tokenElementTotokenElementNodeChildrenMap;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TokenElementNode [tokenElementTotokenElementNodeChildrenMap=");
            builder.append(this.tokenElementTotokenElementNodeChildrenMap);
            builder.append(", valueList=");
            builder.append(this.valueList);
            builder.append(", tokenElement=");
            builder.append(this.tokenElement);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class TokenElementPath<E> {
        private List<E> tokenElementList = new ArrayList();

        public TokenElementPath(List<E> tokenPathElementList) {
            if (tokenPathElementList != null) {
                this.tokenElementList.addAll(tokenPathElementList);
            }
        }

        public TokenElementPath(E ... tokenPathElements) {
            this(Arrays.asList(tokenPathElements));
        }

        protected boolean isValid() {
            return !this.tokenElementList.isEmpty();
        }

        protected List<E> getTokenElementList() {
            return this.tokenElementList;
        }
    }
}

