/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.hierarchy.nodemap;

import java.util.Date;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.structure.hierarchy.nodemap.NodeMap;
import org.omnaest.utils.structure.hierarchy.nodemap.NodeMapImpl;

public class NodeMapFactory {
    public static <K, V, M> NodeMap<K, Map<K, M>> newNodeMap(Map<K, V> map, ModelAndChildExtractor<K, V, M> modelAndChildExtractor) {
        NodeMapImpl retmap = new NodeMapImpl();
        LinkedHashMap<K, M> model = new LinkedHashMap<K, M>();
        if (map != null && modelAndChildExtractor != null) {
            for (K key : map.keySet()) {
                V value = map.get(key);
                boolean isModelValue = modelAndChildExtractor.isModelValue(value);
                if (isModelValue) {
                    M modelValue = modelAndChildExtractor.extractModelValue(value);
                    model.put(key, modelValue);
                    continue;
                }
                NodeMap<K, Map<K, M>> childMap = modelAndChildExtractor.extractChild(value);
                retmap.put(key, childMap);
            }
        }
        retmap.setModel(model);
        return retmap;
    }

    public static NodeMap<String, Map<String, Object>> newNodeMap(Object object) {
        IdentityHashMap<Object, NodeMap<String, Map<String, Object>>> objectToObjectNodeMap = new IdentityHashMap<Object, NodeMap<String, Map<String, Object>>>();
        return NodeMapFactory.newNodeMap(object, objectToObjectNodeMap);
    }

    private static NodeMap<String, Map<String, Object>> newNodeMap(Object object, final Map<Object, NodeMap<String, Map<String, Object>>> objectToObjectNodeMap) {
        Map map = BeanUtils.propertyNameToBeanPropertyValueMap(object);
        ModelAndChildExtractor<String, Object, Object> modelAndChildExtractor = new ModelAndChildExtractor<String, Object, Object>(){

            @Override
            public boolean isModelValue(Object value) {
                return value != null && (value instanceof String || value instanceof Date || ObjectUtils.isPrimitiveOrPrimitiveWrapperType(value.getClass()));
            }

            @Override
            public Object extractModelValue(Object value) {
                return value;
            }

            @Override
            public NodeMap<String, Map<String, Object>> extractChild(Object value) {
                NodeMap nodeMap = (NodeMap)objectToObjectNodeMap.get(value);
                if (nodeMap == null) {
                    nodeMap = NodeMapFactory.newNodeMap(value, (Map<Object, NodeMap<String, Map<String, Object>>>)objectToObjectNodeMap);
                }
                return nodeMap;
            }
        };
        NodeMap<String, Map<String, Object>> retmap = NodeMapFactory.newNodeMap(map, modelAndChildExtractor);
        objectToObjectNodeMap.put(object, retmap);
        return retmap;
    }

    public static NodeMap<String, Map<String, Object>> newNodeMap(Map<String, Object> nestedMap) {
        IdentityHashMap<Object, NodeMap<String, Map<String, Object>>> objectToObjectNodeMap = new IdentityHashMap<Object, NodeMap<String, Map<String, Object>>>();
        return NodeMapFactory.newNodeMap(nestedMap, objectToObjectNodeMap);
    }

    private static NodeMap<String, Map<String, Object>> newNodeMap(Map<String, Object> nestedMap, final Map<Object, NodeMap<String, Map<String, Object>>> objectToObjectNodeMap) {
        ModelAndChildExtractor<String, Object, Object> modelAndChildExtractor = new ModelAndChildExtractor<String, Object, Object>(){

            @Override
            public boolean isModelValue(Object value) {
                return !(value instanceof Map);
            }

            @Override
            public Object extractModelValue(Object value) {
                return value;
            }

            @Override
            public NodeMap<String, Map<String, Object>> extractChild(Object value) {
                Map map = (Map)value;
                return NodeMapFactory.newNodeMap(map, (Map<Object, NodeMap<String, Map<String, Object>>>)objectToObjectNodeMap);
            }
        };
        NodeMap<String, Map<String, Object>> retmap = NodeMapFactory.newNodeMap(nestedMap, modelAndChildExtractor);
        objectToObjectNodeMap.put(nestedMap, retmap);
        return retmap;
    }

    public static <V> NodeMap<String, V> newNodeMapFromHierarchicalKeyMap(Map<String, V> map, String delimiterRegEx) {
        NodeMapImpl retmap = new NodeMapImpl();
        if (map != null) {
            for (String key : map.keySet()) {
                if (key == null) continue;
                V value = map.get(key);
                String[] tokens = key.split(delimiterRegEx);
                if (tokens == null) continue;
                NodeMap currentNodeMap = retmap;
                if (tokens.length > 1) {
                    for (String token : tokens) {
                        if (token == null) continue;
                        NodeMap nodeMap = (NodeMap)currentNodeMap.get(token);
                        if (nodeMap == null) {
                            NodeMapImpl newNodeMap = new NodeMapImpl();
                            currentNodeMap.put(token, newNodeMap);
                            currentNodeMap = newNodeMap;
                            continue;
                        }
                        currentNodeMap = nodeMap;
                    }
                }
                if (currentNodeMap == null) continue;
                currentNodeMap.setModel(value);
            }
        }
        return retmap;
    }

    public static <V> NodeMap<String, Map<String, V>> newNodeMapFromHierarchicalKeyMapWithLastLevelAsMap(Map<String, V> map, String delimiterRegEx) {
        NodeMapImpl<String, Map<String, V>> retmap = new NodeMapImpl<String, Map<String, V>>();
        if (map != null) {
            for (String key : map.keySet()) {
                String token;
                if (key == null) continue;
                V value = map.get(key);
                String[] tokens = key.split(delimiterRegEx);
                if (tokens == null) continue;
                NodeMap currentNodeMap = retmap;
                if (tokens.length <= 1) continue;
                for (int ii = 0; ii < tokens.length - 1; ++ii) {
                    token = tokens[ii];
                    if (token == null) continue;
                    NodeMap nodeMap = (NodeMap)currentNodeMap.get(token);
                    if (nodeMap == null) {
                        NodeMapImpl newNodeMap = new NodeMapImpl();
                        currentNodeMap.put(token, newNodeMap);
                        currentNodeMap = newNodeMap;
                        continue;
                    }
                    currentNodeMap = nodeMap;
                }
                if (currentNodeMap == null) continue;
                LinkedHashMap<String, V> modelMap = (LinkedHashMap<String, V>)currentNodeMap.getModel();
                if (modelMap == null) {
                    modelMap = new LinkedHashMap<String, V>();
                    currentNodeMap.setModel(modelMap);
                }
                if ((token = tokens[tokens.length - 1]) == null) continue;
                modelMap.put(token, value);
            }
        }
        return retmap;
    }

    public static <M> Map<String, M> convertNodeMapToHierarchicalKeyMap(NodeMap<String, M> nodeMap, String delimiter) {
        String parent = null;
        LinkedHashMap retmap = new LinkedHashMap();
        NodeMapFactory.convertNodeMapToHierarchicalKeyMap(nodeMap, parent, retmap, delimiter);
        return retmap;
    }

    private static <M> void convertNodeMapToHierarchicalKeyMap(NodeMap<String, M> nodeMap, String parent, Map<String, M> retmap, String delimiter) {
        if (nodeMap != null) {
            M model;
            if (parent != null && (model = nodeMap.getModel()) != null) {
                retmap.put(parent, model);
            }
            Set keySet = nodeMap.keySet();
            for (String key : keySet) {
                NodeMap subNodeMap = (NodeMap)nodeMap.get(key);
                NodeMapFactory.convertNodeMapToHierarchicalKeyMap(subNodeMap, (parent != null ? parent + delimiter : "") + key, retmap, delimiter);
            }
        }
    }

    public static <M> Map<String, M> convertNodeMapWithLastLevelAsMapToHierarchicalKeyMap(NodeMap<String, Map<String, M>> nodeMap, String delimiter) {
        String parent = null;
        LinkedHashMap retmap = new LinkedHashMap();
        NodeMapFactory.convertNodeMapWithLastLevelAsMapToHierarchicalKeyMap(nodeMap, parent, retmap, delimiter);
        return retmap;
    }

    private static <M> void convertNodeMapWithLastLevelAsMapToHierarchicalKeyMap(NodeMap<String, Map<String, M>> nodeMap, String parent, Map<String, M> retmap, String delimiter) {
        if (nodeMap != null) {
            Map<String, M> modelMap;
            if (parent != null && (modelMap = nodeMap.getModel()) != null) {
                for (String key : modelMap.keySet()) {
                    if (key == null) continue;
                    retmap.put(parent + delimiter + key, modelMap.get(key));
                }
            }
            Set keySet = nodeMap.keySet();
            for (String key : keySet) {
                if (key == null) continue;
                NodeMap subNodeMap = (NodeMap)nodeMap.get(key);
                NodeMapFactory.convertNodeMapWithLastLevelAsMapToHierarchicalKeyMap(subNodeMap, (parent != null ? parent + delimiter : "") + key, retmap, delimiter);
            }
        }
    }

    public static interface ModelAndChildExtractor<K, V, M> {
        public boolean isModelValue(V var1);

        public M extractModelValue(V var1);

        public NodeMap<K, Map<K, M>> extractChild(V var1);
    }
}

