/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.hierarchy.nodemap;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.omnaest.utils.events.exception.ExceptionHandler;
import org.omnaest.utils.structure.container.ByteArrayContainer;
import org.omnaest.utils.structure.hierarchy.nodemap.NodeMap;

public class NodeMapXMLHandler {
    private ExceptionHandler exceptionHandler;
    private String encoding = "utf-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertToXML(String rootTagName, NodeMap<String, Map<String, String>> nodeMap) {
        String retval;
        block14: {
            retval = null;
            if (nodeMap != null) {
                try {
                    XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
                    ByteArrayContainer byteArrayContainer = new ByteArrayContainer();
                    OutputStreamWriter writer = byteArrayContainer.getOutputStreamWriter(this.encoding);
                    XMLStreamWriter xmlStreamWriter = null;
                    try {
                        xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter(writer);
                        xmlStreamWriter.writeStartDocument();
                        xmlStreamWriter.writeStartElement(rootTagName);
                        this.writeNodeMap(nodeMap, xmlStreamWriter);
                        xmlStreamWriter.writeEndElement();
                        xmlStreamWriter.writeEndDocument();
                    }
                    finally {
                        try {
                            if (xmlStreamWriter != null) {
                                xmlStreamWriter.close();
                            }
                        }
                        finally {
                            ((Writer)writer).close();
                        }
                    }
                    retval = byteArrayContainer.toString(this.encoding);
                }
                catch (Exception e) {
                    if (this.exceptionHandler == null) break block14;
                    this.exceptionHandler.handleException(e);
                }
            }
        }
        return retval;
    }

    private void writeNodeMap(NodeMap<String, Map<String, String>> nodeMap, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        if (nodeMap != null) {
            Set keySet;
            Map<String, String> model = nodeMap.getModel();
            if (model != null) {
                for (String field : model.keySet()) {
                    String value = model.get(field);
                    NodeMapXMLHandler.writeFieldAndValue(xmlStreamWriter, field, value);
                }
            }
            if ((keySet = nodeMap.keySet()) != null) {
                for (String nodeName : keySet) {
                    NodeMap subNodeMap = (NodeMap)nodeMap.get(nodeName);
                    if (subNodeMap == null) continue;
                    xmlStreamWriter.writeStartElement(nodeName);
                    this.writeNodeMap(subNodeMap, xmlStreamWriter);
                    xmlStreamWriter.writeEndElement();
                }
            }
        }
    }

    private static void writeFieldAndValue(XMLStreamWriter xmlStreamWriter, String field, String value) throws XMLStreamException {
        String localName = field;
        xmlStreamWriter.writeStartElement(localName);
        xmlStreamWriter.writeCharacters(value);
        xmlStreamWriter.writeEndElement();
    }
}

