/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.hierarchy.tree;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.hierarchy.tree.Tree;
import org.omnaest.utils.structure.hierarchy.tree.TreeNavigator;
import org.omnaest.utils.structure.hierarchy.tree.TreeNode;
import org.omnaest.utils.structure.map.MapUtils;

public class TreeHelper {
    public static <M, TN extends TreeNode<M>, T extends Tree<M, TN>> Map<M, List<M>> treeNodeModelToChildrenTreeNodeModelListMap(T tree) {
        ElementConverter treeNodeToModelConverter;
        Map<TN, List<TN>> map = TreeHelper.treeNodeToChildrenTreeNodeListMap(tree);
        ElementConverter keyElementConverter = treeNodeToModelConverter = new ElementConverter<TN, M>(){

            @Override
            public M convert(TN element) {
                return element != null ? (Object)element.getModel() : null;
            }
        };
        ElementConverter valueElementConverter = new ElementConverter<List<TN>, List<M>>(){

            @Override
            public List<M> convert(List<TN> elementList) {
                return ListUtils.convert(elementList, treeNodeToModelConverter);
            }
        };
        return map == null ? null : MapUtils.convertMap(map, keyElementConverter, valueElementConverter);
    }

    public static <M, TN extends TreeNode<M>, T extends Tree<M, TN>> Map<TN, List<TN>> treeNodeToChildrenTreeNodeListMap(T tree) {
        final LinkedHashMap retmap = new LinkedHashMap();
        TreeNavigator treeNavigator = new TreeNavigator(tree);
        TreeNavigator.TreeNodeVisitor treeNodeVisitor = new TreeNavigator.TreeNodeVisitor<T, TN>(){

            @Override
            public TreeNavigator.TreeNodeVisitor.TraversalControl visit(TN treeNode, TreeNavigator<T, TN> treeNavigator) {
                Object currentTreeNode = treeNavigator.getCurrentTreeNode();
                retmap.put(currentTreeNode, currentTreeNode.getChildrenList());
                return null;
            }
        };
        treeNavigator.traverse(treeNodeVisitor);
        return retmap;
    }
}

