/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.hierarchy.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.omnaest.utils.strings.StringUtils;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.collection.set.SetUtils;
import org.omnaest.utils.structure.element.ElementHolder;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.structure.hierarchy.tree.Tree;
import org.omnaest.utils.structure.hierarchy.tree.TreeNode;

public class TreeNavigator<T extends Tree<?, TN>, TN extends TreeNode> {
    protected final T tree;
    protected TreeNodePathAndCache treeNodePathAndCache = new TreeNodePathAndCache();
    protected boolean navigationSuccessful = true;
    protected boolean cachingChildrenOfPathNodes = true;
    protected TreeNodeTraversal<TreeNodeVisitor<T, TN>> treeNodeTraversal = new TreeNodeTraversal();

    public TreeNavigator(T tree) {
        this.tree = tree;
        this.treeNodePathAndCache.addTreeNodeToTreeNodePath(tree.getTreeRootNode(), -1);
    }

    protected TreeNavigator(T tree, TreeNodePathAndCache treeNodePath, boolean cachingChildrenOfPathNodes) {
        this.tree = tree;
        this.treeNodePathAndCache = treeNodePath;
        this.cachingChildrenOfPathNodes = cachingChildrenOfPathNodes;
    }

    public TreeNavigator(T tree, boolean cachingChildrenOfPathNodes) {
        this(tree);
        this.cachingChildrenOfPathNodes = cachingChildrenOfPathNodes;
    }

    public TreeNavigator<T, TN> fork() {
        return new TreeNavigator<T, TN>(this.tree, this.treeNodePathAndCache.fork(), this.cachingChildrenOfPathNodes);
    }

    public TreeNavigator<T, TN> navigateToFirstChild() {
        int index = 0;
        return this.navigateToChildAt(index);
    }

    public TreeNavigator<T, TN> navigateToLastChild() {
        int index = this.treeNodePathAndCache.determineAndCacheChildrenListOfCurrentTreeNode().size() - 1;
        return this.navigateToChildAt(index);
    }

    public TreeNavigator<T, TN> navigateToChildAt(int index) {
        this.navigationSuccessful = false;
        List childrenList = this.treeNodePathAndCache.getChildrenListOfCurrentTreeNode();
        TreeNode element = (TreeNode)ListUtils.elementAt(childrenList, index);
        if (element != null) {
            this.treeNodePathAndCache.addTreeNodeToTreeNodePath(element, index);
            this.navigationSuccessful = true;
        }
        return this;
    }

    public TreeNavigator<T, TN> navigateToNextSibling(int relativeIndexPosition) {
        return this.navigateToPreviousSibling(-relativeIndexPosition);
    }

    public TreeNavigator<T, TN> navigateToNextSibling() {
        return this.navigateToNextSibling(1);
    }

    public TreeNavigator<T, TN> navigateToPreviousSibling() {
        return this.navigateToPreviousSibling(1);
    }

    public TreeNavigator<T, TN> navigateToPreviousSibling(int relativeIndexPosition) {
        this.navigationSuccessful = false;
        int indexPosition = this.treeNodePathAndCache.determineIndexPositionOfCurrentTreeNodeWithinTheParentChildrenList();
        if (indexPosition >= 0) {
            List childrenListOfParent = this.treeNodePathAndCache.getChildrenListOfParent();
            int newIndexPosition = indexPosition - relativeIndexPosition;
            if (newIndexPosition >= 0 && newIndexPosition < childrenListOfParent.size()) {
                TreeNode treeNode = (TreeNode)childrenListOfParent.get(newIndexPosition);
                this.treeNodePathAndCache.removeLastTreeNodeAndClearUnusedCachedChildrenLists();
                this.treeNodePathAndCache.addTreeNodeToTreeNodePath(treeNode, newIndexPosition);
                this.navigationSuccessful = true;
            }
        }
        return this;
    }

    public boolean hasNextSibling() {
        return this.fork().navigateToNextSibling().isNavigationSuccessful();
    }

    public boolean hasPreviousSibling() {
        return this.fork().navigateToPreviousSibling().isNavigationSuccessful();
    }

    public TreeNavigator<T, TN> navigateToParent() {
        this.navigationSuccessful = false;
        if (this.hasParent()) {
            this.treeNodePathAndCache.removeLastTreeNodeAndClearUnusedCachedChildrenLists();
            this.navigationSuccessful = true;
        }
        return this;
    }

    public boolean hasParent() {
        return this.treeNodePathAndCache.size() > 1;
    }

    public boolean hasChildren() {
        List childrenListOfCurrentTreeNode = this.treeNodePathAndCache.getChildrenListOfCurrentTreeNode();
        return childrenListOfCurrentTreeNode != null && !childrenListOfCurrentTreeNode.isEmpty();
    }

    public TreeNavigator<T, TN> traverse(TreeNodeVisitor<T, TN> ... treeNodeVisitors) {
        return this.traverse(new TreeNodeVisitor.TraversalConfiguration(), treeNodeVisitors);
    }

    public TreeNavigator<T, TN> traverse(TreeNodeVisitor<T, TN> treeNodeVisitor) {
        return this.traverse(new TreeNodeVisitor[]{treeNodeVisitor});
    }

    public TreeNavigator<T, TN> traverse(TreeNodeVisitor.TraversalConfiguration defaultTraversalConfiguration, TreeNodeVisitor<T, TN> treeNodeVisitor) {
        return this.traverse(defaultTraversalConfiguration, new TreeNodeVisitor[]{treeNodeVisitor});
    }

    public TreeNavigator<T, TN> traverse(TreeNodeVisitor.TraversalConfiguration defaultTraversalConfiguration, TreeNodeVisitor<T, TN> ... treeNodeVisitors) {
        this.treeNodeTraversal.traverse(defaultTraversalConfiguration, treeNodeVisitors);
        return this;
    }

    public boolean isNavigationSuccessful() {
        return this.navigationSuccessful;
    }

    public TN getCurrentTreeNode() {
        return this.treeNodePathAndCache.getCurrentTreeNode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        TreeNavigator<T, TN> treeNavigator = this.fork();
        HashSet alreadyTraversedModelSet = new HashSet();
        String indentionString = "";
        boolean isTraversing = true;
        while (isTraversing) {
            boolean alreadyTraversedNode = false;
            TN currentTreeNode = treeNavigator.getCurrentTreeNode();
            if (currentTreeNode != null) {
                Object model = currentTreeNode.getModel();
                builder.append(indentionString);
                builder.append("|--");
                builder.append(String.valueOf(model));
                builder.append(StringUtils.DEFAULT_LINESEPARATOR);
                alreadyTraversedNode = alreadyTraversedModelSet.contains(model);
                if (!alreadyTraversedNode) {
                    alreadyTraversedModelSet.add(model);
                }
            }
            boolean hasNextSibling = treeNavigator.hasNextSibling();
            if (!alreadyTraversedNode && treeNavigator.hasChildren()) {
                indentionString = indentionString + (hasNextSibling ? "|  " : "   ");
                treeNavigator.navigateToFirstChild();
                continue;
            }
            if (hasNextSibling) {
                treeNavigator.navigateToNextSibling();
                continue;
            }
            while (!treeNavigator.hasNextSibling() && treeNavigator.hasParent()) {
                treeNavigator.navigateToParent();
                indentionString = indentionString.substring(0, Math.max(0, indentionString.length() - 3));
            }
            isTraversing = treeNavigator.navigateToNextSibling().isNavigationSuccessful();
        }
        return builder.toString();
    }

    public boolean isCachingChildrenOfPathNodes() {
        return this.cachingChildrenOfPathNodes;
    }

    public void setCachingChildrenOfPathNodes(boolean cachingChildrenOfPathNodes) {
        this.cachingChildrenOfPathNodes = cachingChildrenOfPathNodes;
    }

    public T getTree() {
        return this.tree;
    }

    public List<TN> getTreeNodePathList() {
        return new ArrayList(this.treeNodePathAndCache.getTreeNodePathList());
    }

    protected class TreeNodeTraversal<TNV extends TreeNodeVisitor<T, TN>> {
        protected TreeNodeTraversal() {
        }

        public void traverse(TreeNodeVisitor.TraversalConfiguration defaultTraversalConfiguration, TNV ... treeNodeVisitors) {
            for (TNV treeNodeVisitor : treeNodeVisitors) {
                HashSet visitedTreeNodeSet = new HashSet();
                ElementHolder<TreeNodeVisitor.TraversalConfiguration> traversalConfigurationHolder = new ElementHolder<TreeNodeVisitor.TraversalConfiguration>(defaultTraversalConfiguration);
                this.traverse(treeNodeVisitor, traversalConfigurationHolder, visitedTreeNodeSet);
            }
        }

        protected boolean traverse(TNV treeNodeVisitor, ElementHolder<TreeNodeVisitor.TraversalConfiguration> traversalConfigurationHolder, Set<TN> visitedTreeNodeSet) {
            boolean passesIncludingCurrentNode;
            boolean retval = false;
            Object treeNode = this.getCurrentTreeNode();
            TreeNodeVisitor.TraversalConfiguration traversalConfiguration = (TreeNodeVisitor.TraversalConfiguration)traversalConfigurationHolder.getElement();
            boolean includingAlreadyTraversedNodes = traversalConfiguration.isIncludingAlreadyTraversedNodes();
            boolean includingCurrentNode = traversalConfiguration.isIncludingCurrentNode();
            boolean passesIncludingAlreadyTraversedNodes = includingAlreadyTraversedNodes || !visitedTreeNodeSet.contains(treeNode);
            boolean bl = passesIncludingCurrentNode = includingCurrentNode || !visitedTreeNodeSet.isEmpty();
            if (passesIncludingAlreadyTraversedNodes) {
                TreeNodeVisitor.TraversalControl traversalControl = null;
                if (passesIncludingCurrentNode) {
                    TreeNavigator treeNavigator = this.getTreeNavigatorFork();
                    try {
                        traversalControl = treeNodeVisitor.visit(treeNode, treeNavigator);
                        visitedTreeNodeSet.add(treeNode);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (traversalControl != null && !TreeNodeVisitor.TraversalControl.GO_ON.equals((Object)traversalControl)) {
                        Boolean includingCurrentNode2 = null;
                        Boolean includingAlreadyTraversedNodes2 = null;
                        Boolean includingChildren = null;
                        includingAlreadyTraversedNodes2 = LocalAndReducedTraversalControl.EXCLUDE_ALREADY_TRAVERSED_NODES.getTraversalControlSet().contains((Object)traversalControl) ? Boolean.FALSE : includingAlreadyTraversedNodes2;
                        includingAlreadyTraversedNodes2 = LocalAndReducedTraversalControl.INCLUDE_ALREADY_TRAVERSED_NODES.getTraversalControlSet().contains((Object)traversalControl) ? Boolean.TRUE : includingAlreadyTraversedNodes2;
                        includingChildren = LocalAndReducedTraversalControl.EXCLUDE_CHILDREN.getTraversalControlSet().contains((Object)traversalControl) ? Boolean.FALSE : includingChildren;
                        includingChildren = LocalAndReducedTraversalControl.INCLUDE_CHILDREN.getTraversalControlSet().contains((Object)traversalControl) ? Boolean.TRUE : includingChildren;
                        traversalConfigurationHolder.setElement((Object)traversalConfiguration.copy(includingCurrentNode2, includingAlreadyTraversedNodes2, includingChildren));
                    }
                }
                boolean skipChildren = LocalAndReducedTraversalControl.SKIP_CHILDREN.getTraversalControlSet().contains((Object)traversalControl);
                boolean skipFurtherSiblings = LocalAndReducedTraversalControl.SKIP_FURTHER_SIBLINGS.getTraversalControlSet().contains((Object)traversalControl);
                if (!skipChildren) {
                    this.traverseThroughChildren(treeNodeVisitor, traversalConfigurationHolder, visitedTreeNodeSet);
                }
                retval = !skipFurtherSiblings;
            }
            return retval;
        }

        private TN getCurrentTreeNode() {
            return TreeNavigator.this.getCurrentTreeNode();
        }

        private void traverseThroughChildren(TNV treeNodeVisitor, ElementHolder<TreeNodeVisitor.TraversalConfiguration> traversalConfigurationHolder, Set<TN> visitedTreeNodeSet) {
            if (treeNodeVisitor != null && traversalConfigurationHolder != null && visitedTreeNodeSet != null) {
                TreeNavigator fork = this.getTreeNavigatorFork();
                boolean navigationSuccessful = fork.navigateToFirstChild().isNavigationSuccessful();
                boolean skipFurtherSiblings = false;
                while (navigationSuccessful && !skipFurtherSiblings) {
                    skipFurtherSiblings = !fork.treeNodeTraversal.traverse(treeNodeVisitor, traversalConfigurationHolder, visitedTreeNodeSet);
                    navigationSuccessful = fork.navigateToNextSibling().isNavigationSuccessful();
                }
            }
        }

        private TreeNavigator<T, TN> getTreeNavigatorFork() {
            return TreeNavigator.this.fork();
        }
    }

    protected static enum LocalAndReducedTraversalControl {
        SKIP_CHILDREN(TreeNodeVisitor.TraversalControl.SKIP_CHILDREN, TreeNodeVisitor.TraversalControl.SKIP_CHILDREN_AND_FURTHER_SIBLINGS, TreeNodeVisitor.TraversalControl.GO_ON_EXCLUDE_CHILDREN, TreeNodeVisitor.TraversalControl.GO_ON_EXCLUDE_CHILDREN_AND_ALREADY_TRAVERSED_NODES, TreeNodeVisitor.TraversalControl.GO_ON_EXCLUDE_CHILDREN_AND_INCLUDE_ALREADY_TRAVERSED_NODES, TreeNodeVisitor.TraversalControl.CANCEL_TRAVERSAL),
        SKIP_FURTHER_SIBLINGS(TreeNodeVisitor.TraversalControl.SKIP_FURTHER_SIBLINGS, TreeNodeVisitor.TraversalControl.SKIP_CHILDREN_AND_FURTHER_SIBLINGS, TreeNodeVisitor.TraversalControl.CANCEL_TRAVERSAL),
        EXCLUDE_ALREADY_TRAVERSED_NODES(TreeNodeVisitor.TraversalControl.GO_ON_EXCLUDE_ALREADY_TRAVERSED_NODES, TreeNodeVisitor.TraversalControl.GO_ON_EXCLUDE_CHILDREN_AND_ALREADY_TRAVERSED_NODES, TreeNodeVisitor.TraversalControl.GO_ON_INCLUDE_CHILDREN_AND_EXCLUDE_ALREADY_TRAVERSED_NODES, TreeNodeVisitor.TraversalControl.CANCEL_TRAVERSAL),
        INCLUDE_ALREADY_TRAVERSED_NODES(TreeNodeVisitor.TraversalControl.GO_ON_INCLUDE_ALREADY_TRAVERSED_NODES, TreeNodeVisitor.TraversalControl.GO_ON_EXCLUDE_CHILDREN_AND_INCLUDE_ALREADY_TRAVERSED_NODES, TreeNodeVisitor.TraversalControl.GO_ON_INCLUDE_CHILDREN_AND_ALREADY_TRAVERSED_NODES),
        EXCLUDE_CHILDREN(TreeNodeVisitor.TraversalControl.GO_ON_EXCLUDE_CHILDREN, TreeNodeVisitor.TraversalControl.GO_ON_EXCLUDE_CHILDREN_AND_ALREADY_TRAVERSED_NODES, TreeNodeVisitor.TraversalControl.GO_ON_EXCLUDE_CHILDREN_AND_INCLUDE_ALREADY_TRAVERSED_NODES, TreeNodeVisitor.TraversalControl.CANCEL_TRAVERSAL),
        INCLUDE_CHILDREN(TreeNodeVisitor.TraversalControl.GO_ON_INCLUDE_CHILDREN, TreeNodeVisitor.TraversalControl.GO_ON_INCLUDE_CHILDREN_AND_ALREADY_TRAVERSED_NODES, TreeNodeVisitor.TraversalControl.GO_ON_INCLUDE_CHILDREN_AND_EXCLUDE_ALREADY_TRAVERSED_NODES);

        private final TreeNodeVisitor.TraversalControl[] traversalControls;

        private LocalAndReducedTraversalControl(TreeNodeVisitor.TraversalControl ... traversalControls) {
            this.traversalControls = traversalControls;
        }

        public TreeNodeVisitor.TraversalControl[] getTraversalControls() {
            return this.traversalControls;
        }

        public Set<TreeNodeVisitor.TraversalControl> getTraversalControlSet() {
            return SetUtils.valueOf(this.traversalControls);
        }
    }

    protected class TreeNodePathAndCache {
        private final List<TN> treeNodePathList = new ArrayList();
        private final List<Integer> treeNodeIndexWithinParentChildrenListList = new ArrayList<Integer>();
        protected final Map<TN, List<TN>> treeNodeToChildrenListMap = new HashMap();

        protected TreeNodePathAndCache() {
        }

        public TreeNodePathAndCache fork() {
            TreeNodePathAndCache retval = new TreeNodePathAndCache();
            retval.treeNodePathList.addAll(this.treeNodePathList);
            retval.treeNodeIndexWithinParentChildrenListList.addAll(this.treeNodeIndexWithinParentChildrenListList);
            retval.treeNodeToChildrenListMap.putAll(this.treeNodeToChildrenListMap);
            return retval;
        }

        public void addTreeNodeToTreeNodePath(TN treeNode, Integer indexWithinParentChildrenList) {
            if (treeNode != null) {
                this.treeNodePathList.add(treeNode);
                this.treeNodeIndexWithinParentChildrenListList.add(indexWithinParentChildrenList);
            }
        }

        private List<TN> determineAndCacheChildrenListOfCurrentTreeNode() {
            List retlist = null;
            Object currentTreeNode = this.getCurrentTreeNode();
            if (currentTreeNode != null) {
                retlist = this.determineAndCacheChildrenListOf(currentTreeNode);
            }
            return retlist;
        }

        private List<TN> determineAndCacheChildrenListOf(TN treeNode) {
            List<Object> retlist = null;
            if (treeNode != null && (retlist = this.treeNodeToChildrenListMap.get(treeNode)) == null) {
                retlist = treeNode.getChildrenList();
                if (TreeNavigator.this.cachingChildrenOfPathNodes) {
                    this.treeNodeToChildrenListMap.put(treeNode, retlist);
                }
            }
            return retlist;
        }

        public int size() {
            return this.treeNodePathList.size();
        }

        public boolean isEmpty() {
            return this.treeNodePathList.isEmpty();
        }

        public TN getCurrentTreeNode() {
            return (TreeNode)ListUtils.lastElement(this.treeNodePathList);
        }

        public void removeLastTreeNodeAndClearUnusedCachedChildrenLists() {
            TreeNode treeNodeRemoved = (TreeNode)ListUtils.removeLast(this.treeNodePathList);
            ListUtils.removeLast(this.treeNodeIndexWithinParentChildrenListList);
            if (treeNodeRemoved != null) {
                this.treeNodeToChildrenListMap.keySet().retainAll(this.treeNodePathList);
            }
        }

        public List<TN> getChildrenListFor(TN treeNode) {
            return treeNode != null ? this.determineAndCacheChildrenListOf(treeNode) : new ArrayList();
        }

        public TN getParent() {
            int inverseIndex = 1;
            return (TreeNode)ListUtils.elementAtInverseIndex(this.treeNodePathList, inverseIndex);
        }

        public List<TN> getChildrenListOfParent() {
            return this.getChildrenListFor(this.getParent());
        }

        public List<TN> getChildrenListOfCurrentTreeNode() {
            return this.getChildrenListFor(this.getCurrentTreeNode());
        }

        public int determineIndexPositionOfCurrentTreeNodeWithinTheParentChildrenList() {
            int size = this.size();
            return size < 2 ? -1 : this.treeNodeIndexWithinParentChildrenListList.get(size - 1);
        }

        public List<TN> getTreeNodePathList() {
            return this.treeNodePathList;
        }
    }

    public static interface TreeNodeVisitor<T extends Tree<?, TN>, TN extends TreeNode> {
        public TraversalControl visit(TN var1, TreeNavigator<T, TN> var2);

        public static class TraversalConfiguration {
            private boolean includingCurrentNode = true;
            private boolean includingAlreadyTraversedNodes = false;
            private boolean includingChildren = true;

            public TraversalConfiguration copy(Boolean includingCurrentNode, Boolean includingAlreadyTraversedNodes, Boolean includingChildren) {
                boolean includingCurrentNodeMerged = ObjectUtils.defaultIfNull(includingCurrentNode, this.includingCurrentNode);
                boolean includingAlreadyTraversedNodesMerged = ObjectUtils.defaultIfNull(includingAlreadyTraversedNodes, this.includingAlreadyTraversedNodes);
                boolean includingChildrenMerged = ObjectUtils.defaultIfNull(includingChildren, this.includingChildren);
                return new TraversalConfiguration(includingCurrentNodeMerged, includingAlreadyTraversedNodesMerged, includingChildrenMerged);
            }

            public TraversalConfiguration(boolean includingCurrentNode, boolean includingAlreadyTraversedNodes, boolean includingChildren) {
                this.includingCurrentNode = includingCurrentNode;
                this.includingAlreadyTraversedNodes = includingAlreadyTraversedNodes;
                this.includingChildren = includingChildren;
            }

            public TraversalConfiguration() {
            }

            public boolean isIncludingCurrentNode() {
                return this.includingCurrentNode;
            }

            public boolean isIncludingAlreadyTraversedNodes() {
                return this.includingAlreadyTraversedNodes;
            }

            public boolean isIncludingChildren() {
                return this.includingChildren;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("TraversalConfiguration [includingCurrentNode=");
                builder.append(this.includingCurrentNode);
                builder.append(", includingAlreadyTraversedNodes=");
                builder.append(this.includingAlreadyTraversedNodes);
                builder.append(", includingChildren=");
                builder.append(this.includingChildren);
                builder.append("]");
                return builder.toString();
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.includingAlreadyTraversedNodes ? 1231 : 1237);
                result = 31 * result + (this.includingChildren ? 1231 : 1237);
                result = 31 * result + (this.includingCurrentNode ? 1231 : 1237);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof TraversalConfiguration)) {
                    return false;
                }
                TraversalConfiguration other = (TraversalConfiguration)obj;
                if (this.includingAlreadyTraversedNodes != other.includingAlreadyTraversedNodes) {
                    return false;
                }
                if (this.includingChildren != other.includingChildren) {
                    return false;
                }
                return this.includingCurrentNode == other.includingCurrentNode;
            }
        }

        public static enum TraversalControl {
            GO_ON,
            GO_ON_INCLUDE_ALREADY_TRAVERSED_NODES,
            GO_ON_EXCLUDE_ALREADY_TRAVERSED_NODES,
            GO_ON_INCLUDE_CHILDREN,
            GO_ON_EXCLUDE_CHILDREN,
            GO_ON_INCLUDE_CHILDREN_AND_ALREADY_TRAVERSED_NODES,
            GO_ON_EXCLUDE_CHILDREN_AND_ALREADY_TRAVERSED_NODES,
            GO_ON_EXCLUDE_CHILDREN_AND_INCLUDE_ALREADY_TRAVERSED_NODES,
            GO_ON_INCLUDE_CHILDREN_AND_EXCLUDE_ALREADY_TRAVERSED_NODES,
            SKIP_CHILDREN,
            SKIP_FURTHER_SIBLINGS,
            SKIP_CHILDREN_AND_FURTHER_SIBLINGS,
            CANCEL_TRAVERSAL;

        }
    }
}

