/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.hierarchy.tree.object;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.omnaest.utils.beans.BeanUtils;
import org.omnaest.utils.beans.result.BeanPropertyAccessor;
import org.omnaest.utils.structure.collection.list.ListUtils;
import org.omnaest.utils.structure.element.ObjectUtils;
import org.omnaest.utils.structure.element.converter.ElementConverter;
import org.omnaest.utils.structure.hierarchy.tree.TreeNode;
import org.omnaest.utils.structure.hierarchy.tree.object.ObjectTree;
import org.omnaest.utils.structure.hierarchy.tree.object.ObjectTreeNode;

public class ObjectToTreeNodeAdapter
implements ObjectTreeNode,
ObjectTree {
    protected final ObjectTreeNode.ObjectModel objectModel;

    public ObjectToTreeNodeAdapter(ObjectTreeNode.ObjectModel objectModel) {
        this.objectModel = objectModel;
    }

    public ObjectToTreeNodeAdapter(Object object) {
        this.objectModel = new ObjectTreeNode.ObjectModel(object);
    }

    @Override
    public ObjectTreeNode.ObjectModel getModel() {
        return this.objectModel;
    }

    @Override
    public List<TreeNode<ObjectTreeNode.ObjectModel>> getChildrenList() {
        final Object object = this.objectModel.getObject();
        Class<?> type = object != null ? object.getClass() : null;
        boolean isPrimitiveType = type != null && type.isPrimitive();
        boolean isStringType = type != null && String.class.equals(type);
        boolean isPrimitiveWrapperType = ObjectUtils.isPrimitiveWrapperType(type);
        Set<BeanPropertyAccessor<?>> beanPropertyAccessorSet = !isPrimitiveType && !isStringType && !isPrimitiveWrapperType ? BeanUtils.beanPropertyAccessorSet(type) : null;
        ElementConverter<BeanPropertyAccessor<Object>, TreeNode<ObjectTreeNode.ObjectModel>> elementConverter = new ElementConverter<BeanPropertyAccessor<Object>, TreeNode<ObjectTreeNode.ObjectModel>>(){

            @Override
            public TreeNode<ObjectTreeNode.ObjectModel> convert(BeanPropertyAccessor<Object> beanPropertyAccessor) {
                Method getterMethod = beanPropertyAccessor.getMethodGetter();
                Method setterMethod = beanPropertyAccessor.getMethodSetter();
                Field field = beanPropertyAccessor.getField();
                String propertyName = beanPropertyAccessor.getPropertyName();
                Object value = beanPropertyAccessor.getPropertyValue(object);
                return new ObjectToTreeNodeAdapter(new ObjectTreeNode.ObjectModel(value, getterMethod, setterMethod, field, propertyName));
            }
        };
        List<TreeNode<ObjectTreeNode.ObjectModel>> retlist = ListUtils.convert(beanPropertyAccessorSet, elementConverter);
        Comparator<TreeNode<ObjectTreeNode.ObjectModel>> comparator = new Comparator<TreeNode<ObjectTreeNode.ObjectModel>>(){

            @Override
            public int compare(TreeNode<ObjectTreeNode.ObjectModel> o1, TreeNode<ObjectTreeNode.ObjectModel> o2) {
                return o1 == null || o2 == null || o1.getModel() == null || o2.getModel() == null ? 0 : o1.getModel().getPropertyName().compareTo(o2.getModel().getPropertyName());
            }
        };
        Collections.sort(retlist, comparator);
        return retlist;
    }

    @Override
    public ObjectTreeNode getTreeRootNode() {
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ObjectToTreeNodeAdapter [objectModel=");
        builder.append(this.objectModel);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.objectModel == null ? 0 : this.objectModel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectToTreeNodeAdapter)) {
            return false;
        }
        ObjectToTreeNodeAdapter other = (ObjectToTreeNodeAdapter)obj;
        return !(this.objectModel == null ? other.objectModel != null : !this.objectModel.equals(other.objectModel));
    }
}

