/*
 * Decompiled with CFR 0.152.
 */
package org.omnaest.utils.structure.hierarchy.tree.object;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.omnaest.utils.structure.hierarchy.tree.TreeNode;

public interface ObjectTreeNode
extends TreeNode<ObjectModel> {

    public static class ObjectModel {
        private final Object object;
        private final Method setterMethod;
        private final Method getterMethod;
        private final Field field;
        private final String propertyName;

        public ObjectModel(Object object, Method getterMethod, Method setterMethod, Field field, String propertyName) {
            this.object = object;
            this.getterMethod = getterMethod;
            this.setterMethod = setterMethod;
            this.field = field;
            this.propertyName = propertyName;
        }

        public ObjectModel(Object object) {
            this.object = object;
            this.setterMethod = null;
            this.getterMethod = null;
            this.field = null;
            this.propertyName = null;
        }

        public Object getObject() {
            return this.object;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ObjectModel [object=");
            builder.append(this.object);
            builder.append(", setterMethod=");
            builder.append(this.setterMethod);
            builder.append(", getterMethod=");
            builder.append(this.getterMethod);
            builder.append(", field=");
            builder.append(this.field);
            builder.append(", propertyName=");
            builder.append(this.propertyName);
            builder.append("]");
            return builder.toString();
        }

        public Method getSetterMethod() {
            return this.setterMethod;
        }

        public Method getGetterMethod() {
            return this.getterMethod;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ObjectModel)) {
                return false;
            }
            ObjectModel other = (ObjectModel)obj;
            return !(this.object == null ? other.object != null : !this.object.equals(other.object));
        }
    }
}

